/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.updatechecker;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.milkteamc.autotreechop.libs.updatechecker.UpdateCheckEvent;
import org.milkteamc.autotreechop.libs.updatechecker.UpdateChecker;
import org.milkteamc.autotreechop.libs.updatechecker.UpdateCheckerMessages;

class UpdateCheckListener
implements Listener {
    private final UpdateChecker instance = UpdateChecker.getInstance();

    UpdateCheckListener() {
    }

    @EventHandler
    public void notifyOnJoin(PlayerJoinEvent playerJoinEvent) {
        if (!this.instance.isCheckedAtLeastOnce()) {
            return;
        }
        Player player = playerJoinEvent.getPlayer();
        if (player.isOp() && this.instance.isNotifyOpsOnJoin() || this.instance.getNotifyPermission() != null && player.hasPermission(this.instance.getNotifyPermission())) {
            UpdateCheckerMessages.printCheckResultToPlayer(player, false);
        }
    }

    @EventHandler
    public void onUpdateCheck(UpdateCheckEvent event) {
        if (!this.instance.isCheckedAtLeastOnce()) {
            return;
        }
        if (!this.instance.isNotifyRequesters()) {
            return;
        }
        if (event.getRequesters() == null) {
            return;
        }
        for (CommandSender commandSender : event.getRequesters()) {
            if (commandSender instanceof Player) {
                UpdateCheckerMessages.printCheckResultToPlayer((Player)commandSender, true);
                continue;
            }
            UpdateCheckerMessages.printCheckResultToConsole(event);
        }
    }
}

