/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.updatechecker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.milkteamc.autotreechop.libs.updatechecker.UpdateChecker;

public class UserAgentBuilder {
    private final StringBuilder builder = new StringBuilder("JEFF-Media-GbR-SpigotUpdateChecker/").append("3.0.4");
    private final UpdateChecker instance = UpdateChecker.getInstance();
    private final List<String> list = new ArrayList<String>();
    private final Plugin plugin = this.instance.getPlugin();

    public static UserAgentBuilder getDefaultUserAgent() {
        return new UserAgentBuilder().addPluginNameAndVersion().addServerVersion().addBukkitVersion();
    }

    public UserAgentBuilder addBukkitVersion() {
        this.list.add("BukkitVersion/" + Bukkit.getBukkitVersion());
        return this;
    }

    public UserAgentBuilder addKeyValue(String key, String value) {
        this.list.add(key + "/" + value);
        return this;
    }

    public UserAgentBuilder addPlaintext(String text) {
        this.list.add(text);
        return this;
    }

    public UserAgentBuilder addPluginNameAndVersion() {
        this.list.add(this.plugin.getName() + "/" + this.plugin.getDescription().getVersion());
        return this;
    }

    public UserAgentBuilder addServerVersion() {
        this.list.add("ServerVersion/" + Bukkit.getVersion());
        return this;
    }

    public UserAgentBuilder addSpigotUserId() {
        String uid = this.instance.isUsingPaidVersion() ? this.instance.getSpigotUserId() : "none";
        this.list.add("SpigotUID/" + uid);
        return this;
    }

    public UserAgentBuilder addUsingPaidVersion() {
        this.list.add("Paid/" + this.instance.isUsingPaidVersion());
        return this;
    }

    protected String build() {
        if (this.list.size() > 0) {
            this.builder.append(" (");
            Iterator<String> it = this.list.iterator();
            while (it.hasNext()) {
                this.builder.append(it.next());
                if (!it.hasNext()) continue;
                this.builder.append(", ");
            }
            this.builder.append(")");
        }
        return this.builder.toString();
    }
}

