/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.utils;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.milkteamc.autotreechop.AutoTreeChop;
import org.milkteamc.autotreechop.Config;
import org.milkteamc.autotreechop.PlayerConfig;
import org.milkteamc.autotreechop.utils.AsyncTaskScheduler;
import org.milkteamc.autotreechop.utils.BatchProcessor;
import org.milkteamc.autotreechop.utils.BlockDiscoveryUtils;
import org.milkteamc.autotreechop.utils.EffectUtils;
import org.milkteamc.autotreechop.utils.PermissionUtils;
import org.milkteamc.autotreechop.utils.ProtectionCheckUtils;
import org.milkteamc.autotreechop.utils.SessionManager;

public class LeafRemovalUtils {
    private final AutoTreeChop plugin;
    private final AsyncTaskScheduler scheduler;
    private final BatchProcessor batchProcessor;
    private final SessionManager sessionManager;
    private final Set<Location> processingLeafLocations = ConcurrentHashMap.newKeySet();

    public LeafRemovalUtils(AutoTreeChop plugin) {
        this.plugin = plugin;
        this.scheduler = new AsyncTaskScheduler(plugin);
        this.batchProcessor = new BatchProcessor(plugin, this.scheduler);
        this.sessionManager = SessionManager.getInstance();
    }

    public void processLeafRemoval(Block originalLogBlock, Player player, Config config, PlayerConfig playerConfig, ProtectionCheckUtils.ProtectionHooks hooks) {
        if (!config.isLeafRemovalEnabled()) {
            return;
        }
        if (!player.hasPermission("autotreechop.leaves")) {
            return;
        }
        String playerKey = player.getUniqueId().toString();
        if (this.sessionManager.hasActiveLeafRemovalSession(playerKey)) {
            return;
        }
        String sessionId = this.sessionManager.startLeafRemovalSession(playerKey);
        if (sessionId == null) {
            return;
        }
        long delayTicks = config.getLeafRemovalDelayTicks();
        this.scheduler.scheduleDelayed(originalLogBlock.getLocation(), () -> this.startLeafRemoval(originalLogBlock, player, config, playerConfig, hooks, sessionId, playerKey), delayTicks);
    }

    private void startLeafRemoval(Block originalLogBlock, Player player, Config config, PlayerConfig playerConfig, ProtectionCheckUtils.ProtectionHooks hooks, String sessionId, String playerKey) {
        Runnable discoveryTask = () -> {
            Set<Location> removedLogs = this.sessionManager.getRemovedLogs(sessionId);
            int radius = config.getLeafRemovalRadius();
            Set<Block> leavesToRemove = radius > 10 ? BlockDiscoveryUtils.discoverLeavesBFS(originalLogBlock, radius, config, removedLogs) : BlockDiscoveryUtils.discoverLeavesRadial(originalLogBlock, radius, config, removedLogs);
            Runnable executionTask = () -> this.executeLeafRemoval(leavesToRemove, player, config, playerConfig, hooks, sessionId, playerKey);
            this.scheduler.runTask(originalLogBlock.getLocation(), executionTask);
        };
        this.scheduler.runTaskAsync(config, discoveryTask);
    }

    private void executeLeafRemoval(Set<Block> leavesToRemove, Player player, Config config, PlayerConfig playerConfig, ProtectionCheckUtils.ProtectionHooks hooks, String sessionId, String playerKey) {
        if (leavesToRemove.isEmpty()) {
            this.sessionManager.endLeafRemovalSession(sessionId, playerKey);
            return;
        }
        ArrayList<Location> leavesList = new ArrayList<Location>();
        for (Block block : leavesToRemove) {
            leavesList.add(block.getLocation());
        }
        int batchSize = BatchProcessor.getOptimalBatchSize(leavesList.size(), config.getLeafRemovalBatchSize());
        this.batchProcessor.processBatchWithTermination(leavesList, 0, batchSize, (location, index) -> {
            if (config.getLeafRemovalCountsTowardsLimit() && !PermissionUtils.hasVipBlock(player, playerConfig, config) && playerConfig.getDailyBlocksBroken() >= config.getMaxBlocksPerDay()) {
                return false;
            }
            Block leafBlock = location.getBlock();
            boolean removed = this.removeLeafBlock(leafBlock, player, config, playerConfig, hooks);
            return true;
        }, () -> this.sessionManager.endLeafRemovalSession(sessionId, playerKey));
    }

    private boolean removeLeafBlock(Block leafBlock, Player player, Config config, PlayerConfig playerConfig, ProtectionCheckUtils.ProtectionHooks hooks) {
        Location leafLocation = leafBlock.getLocation();
        if (this.processingLeafLocations.contains(leafLocation)) {
            return false;
        }
        if (!ProtectionCheckUtils.canModifyBlock(player, leafLocation, hooks)) {
            return false;
        }
        this.processingLeafLocations.add(leafLocation);
        if (config.isCallBlockBreakEvent()) {
            BlockBreakEvent breakEvent = new BlockBreakEvent(leafBlock, player);
            this.plugin.getServer().getPluginManager().callEvent((Event)breakEvent);
            if (breakEvent.isCancelled()) {
                this.processingLeafLocations.remove(leafLocation);
                return false;
            }
        }
        if (config.getLeafRemovalVisualEffects()) {
            EffectUtils.showLeafRemovalEffect(player, leafBlock);
        }
        if (config.getLeafRemovalDropItems()) {
            leafBlock.breakNaturally();
        } else {
            leafBlock.setType(Material.AIR, false);
        }
        if (config.getLeafRemovalCountsTowardsLimit()) {
            playerConfig.incrementDailyBlocksBroken();
        }
        this.processingLeafLocations.remove(leafLocation);
        return true;
    }
}

