/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.events;

import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.milkteamc.autotreechop.AutoTreeChop;
import org.milkteamc.autotreechop.PlayerConfig;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.ComponentLike;
import org.milkteamc.autotreechop.utils.BlockDiscoveryUtils;
import org.milkteamc.autotreechop.utils.EffectUtils;
import org.milkteamc.autotreechop.utils.PermissionUtils;
import org.milkteamc.autotreechop.utils.ProtectionCheckUtils;
import org.milkteamc.autotreechop.utils.SessionManager;

public class BlockBreakListener
implements Listener {
    private final AutoTreeChop plugin;

    public BlockBreakListener(AutoTreeChop plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        PlayerConfig playerConfig = this.plugin.getPlayerConfig(playerUUID);
        Block block = event.getBlock();
        ItemStack tool = player.getInventory().getItemInMainHand();
        Location location = block.getLocation();
        if (BlockDiscoveryUtils.isLeafBlock(block.getType(), this.plugin.getPluginConfig())) {
            UUID uuid = player.getUniqueId();
            if (SessionManager.getInstance().hasActiveLeafRemovalSession(uuid.toString())) {
                return;
            }
        }
        if (SessionManager.getInstance().isLocationProcessing(playerUUID, location)) {
            return;
        }
        if (this.plugin.getCooldownManager().isInCooldown(playerUUID)) {
            AutoTreeChop.sendMessage((CommandSender)player, (ComponentLike)AutoTreeChop.STILL_IN_COOLDOWN_MESSAGE.insertNumber("cooldown_time", this.plugin.getCooldownManager().getRemainingCooldown(playerUUID)));
            event.setCancelled(true);
            return;
        }
        Material material = block.getType();
        if (playerConfig.isAutoTreeChopEnabled() && BlockDiscoveryUtils.isLog(material, this.plugin.getPluginConfig())) {
            if (!PermissionUtils.hasVipBlock(player, playerConfig, this.plugin.getPluginConfig()) && playerConfig.getDailyBlocksBroken() >= this.plugin.getPluginConfig().getMaxBlocksPerDay()) {
                EffectUtils.sendMaxBlockLimitReachedMessage(player, block, AutoTreeChop.HIT_MAX_BLOCK_MESSAGE);
                event.setCancelled(true);
                return;
            }
            if (!PermissionUtils.hasVipUses(player, playerConfig, this.plugin.getPluginConfig()) && playerConfig.getDailyUses() >= this.plugin.getPluginConfig().getMaxUsesPerDay()) {
                AutoTreeChop.sendMessage((CommandSender)player, AutoTreeChop.HIT_MAX_USAGE_MESSAGE);
                return;
            }
            if (this.plugin.getPluginConfig().isVisualEffect()) {
                EffectUtils.showChopEffect(player, block);
            }
            event.setCancelled(true);
            ProtectionCheckUtils.ProtectionHooks hooks = new ProtectionCheckUtils.ProtectionHooks(this.plugin.isWorldGuardEnabled(), this.plugin.getWorldGuardHook(), this.plugin.isResidenceEnabled(), this.plugin.getResidenceHook(), this.plugin.isGriefPreventionEnabled(), this.plugin.getGriefPreventionHook(), this.plugin.isLandsEnabled(), this.plugin.getLandsHook());
            this.plugin.getTreeChopUtils().chopTree(block, player, this.plugin.getPluginConfig().isStopChoppingIfNotConnected(), tool, location, this.plugin.getPluginConfig(), playerConfig, hooks);
        }
    }
}

