/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.command;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.milkteamc.autotreechop.AutoTreeChop;
import org.milkteamc.autotreechop.Config;
import org.milkteamc.autotreechop.PlayerConfig;
import org.milkteamc.autotreechop.libs.tinytranslations.BukkitTinyTranslations;
import org.milkteamc.autotreechop.libs.tinytranslations.Message;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.ComponentLike;

public class Command
implements CommandExecutor {
    private final AutoTreeChop plugin;
    private final Config config;

    public Command(AutoTreeChop plugin) {
        this.plugin = plugin;
        this.config = plugin.getPluginConfig();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command cmd, @NotNull String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("autotreechop") && !cmd.getName().equalsIgnoreCase("atc")) {
            return false;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (sender.hasPermission("autotreechop.reload")) {
                this.config.load();
                sender.sendMessage("Config reloaded successfully.");
                sender.sendMessage("Some features might need a fully restart to change properly!");
            } else {
                AutoTreeChop.sendMessage(sender, AutoTreeChop.NO_PERMISSION_MESSAGE);
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("about")) {
            sender.sendMessage("AutoTreeChop - " + this.plugin.getDescription().getVersion() + " is made by MilkTeaMC team and contributors");
            sender.sendMessage("This JAR and the source code is licensed under the GNU General Public License v3.0 (GPL-3.0)");
            sender.sendMessage("GitHub: https://github.com/milkteamc/autotreechop");
            sender.sendMessage("Discord: https://discord.gg/uQ4UXANnP2");
            sender.sendMessage("Modrinth: https://modrinth.com/plugin/autotreechop");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("enable-all")) {
            if (sender.hasPermission("autotreechop.other") || sender.hasPermission("autotreechop.op")) {
                this.toggleAutoTreeChopForAll(sender, true);
                AutoTreeChop.sendMessage(sender, (ComponentLike)AutoTreeChop.ENABLED_FOR_OTHER_MESSAGE.insertString("player", "everyone"));
            } else {
                AutoTreeChop.sendMessage(sender, AutoTreeChop.NO_PERMISSION_MESSAGE);
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("disable-all")) {
            if (sender.hasPermission("autotreechop.other") || sender.hasPermission("autotreechop.op")) {
                this.toggleAutoTreeChopForAll(sender, false);
                AutoTreeChop.sendMessage(sender, (ComponentLike)AutoTreeChop.DISABLED_FOR_OTHER_MESSAGE.insertString("player", "everyone"));
            } else {
                AutoTreeChop.sendMessage(sender, AutoTreeChop.NO_PERMISSION_MESSAGE);
            }
            return true;
        }
        if (!(sender instanceof Player)) {
            if (args.length > 0) {
                this.handleTargetPlayerToggle(sender, args[0]);
            } else {
                AutoTreeChop.sendMessage(sender, AutoTreeChop.ONLY_PLAYERS_MESSAGE);
            }
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("autotreechop.use")) {
            AutoTreeChop.sendMessage((CommandSender)player, AutoTreeChop.NO_PERMISSION_MESSAGE);
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("usage")) {
            this.handleUsageCommand(player);
            return true;
        }
        if (args.length > 0) {
            this.handleTargetPlayerToggle((CommandSender)player, args[0]);
            return true;
        }
        if (!this.config.getCommandToggle()) {
            AutoTreeChop.sendMessage((CommandSender)player, AutoTreeChop.NO_PERMISSION_MESSAGE);
            return true;
        }
        this.toggleAutoTreeChop(player, player.getUniqueId());
        return true;
    }

    private void handleUsageCommand(Player player) {
        if (!player.hasPermission("autotreechop.vip")) {
            PlayerConfig playerConfig = this.plugin.getPlayerConfig(player.getUniqueId());
            BukkitTinyTranslations.sendMessage((CommandSender)player, (ComponentLike)((Message)AutoTreeChop.USAGE_MESSAGE.insertNumber("current_uses", playerConfig.getDailyUses())).insertNumber("max_uses", this.config.getMaxUsesPerDay()));
            BukkitTinyTranslations.sendMessage((CommandSender)player, (ComponentLike)((Message)AutoTreeChop.BLOCKS_BROKEN_MESSAGE.insertNumber("current_blocks", playerConfig.getDailyBlocksBroken())).insertNumber("max_blocks", this.config.getMaxBlocksPerDay()));
        } else if (player.hasPermission("autotreechop.vip") && this.config.getLimitVipUsage()) {
            PlayerConfig playerConfig = this.plugin.getPlayerConfig(player.getUniqueId());
            BukkitTinyTranslations.sendMessage((CommandSender)player, (ComponentLike)((Message)AutoTreeChop.USAGE_MESSAGE.insertNumber("current_uses", playerConfig.getDailyUses())).insertNumber("max_uses", this.config.getVipUsesPerDay()));
            BukkitTinyTranslations.sendMessage((CommandSender)player, (ComponentLike)((Message)AutoTreeChop.BLOCKS_BROKEN_MESSAGE.insertNumber("current_blocks", playerConfig.getDailyBlocksBroken())).insertNumber("max_blocks", this.config.getVipBlocksPerDay()));
        } else if (player.hasPermission("autotreechop.vip") && !this.config.getLimitVipUsage()) {
            PlayerConfig playerConfig = this.plugin.getPlayerConfig(player.getUniqueId());
            BukkitTinyTranslations.sendMessage((CommandSender)player, (ComponentLike)((Message)AutoTreeChop.USAGE_MESSAGE.insertNumber("current_uses", playerConfig.getDailyUses())).insertString("max_uses", "\u221e"));
            BukkitTinyTranslations.sendMessage((CommandSender)player, (ComponentLike)((Message)AutoTreeChop.BLOCKS_BROKEN_MESSAGE.insertNumber("current_blocks", playerConfig.getDailyBlocksBroken())).insertString("max_blocks", "\u221e"));
        }
    }

    private void handleTargetPlayerToggle(CommandSender sender, String targetPlayerName) {
        Player targetPlayer = Bukkit.getPlayer((String)targetPlayerName);
        if (targetPlayer == null) {
            sender.sendMessage("Player not found: " + targetPlayerName);
            return;
        }
        UUID targetUUID = targetPlayer.getUniqueId();
        PlayerConfig playerConfig = this.plugin.getPlayerConfig(targetUUID);
        boolean autoTreeChopEnabled = !playerConfig.isAutoTreeChopEnabled();
        playerConfig.setAutoTreeChopEnabled(autoTreeChopEnabled);
        if (autoTreeChopEnabled) {
            AutoTreeChop.sendMessage(sender, (ComponentLike)AutoTreeChop.ENABLED_FOR_OTHER_MESSAGE.insertString("player", targetPlayer.getName()));
            AutoTreeChop.sendMessage((CommandSender)targetPlayer, (ComponentLike)AutoTreeChop.ENABLED_BY_OTHER_MESSAGE.insertString("player", sender.getName()));
        } else {
            AutoTreeChop.sendMessage(sender, (ComponentLike)AutoTreeChop.DISABLED_FOR_OTHER_MESSAGE.insertString("player", targetPlayer.getName()));
            AutoTreeChop.sendMessage((CommandSender)targetPlayer, (ComponentLike)AutoTreeChop.DISABLED_BY_OTHER_MESSAGE.insertString("player", sender.getName()));
        }
    }

    private void toggleAutoTreeChop(Player player, UUID playerUUID) {
        PlayerConfig playerConfig = this.plugin.getPlayerConfig(playerUUID);
        boolean autoTreeChopEnabled = !playerConfig.isAutoTreeChopEnabled();
        playerConfig.setAutoTreeChopEnabled(autoTreeChopEnabled);
        if (autoTreeChopEnabled) {
            BukkitTinyTranslations.sendMessage((CommandSender)player, AutoTreeChop.ENABLED_MESSAGE);
        } else {
            BukkitTinyTranslations.sendMessage((CommandSender)player, AutoTreeChop.DISABLED_MESSAGE);
        }
    }

    private void toggleAutoTreeChopForAll(CommandSender sender, boolean autoTreeChopEnabled) {
        Message message = autoTreeChopEnabled ? (Message)AutoTreeChop.ENABLED_BY_OTHER_MESSAGE.insertString("player", sender.getName()) : (Message)AutoTreeChop.DISABLED_BY_OTHER_MESSAGE.insertString("player", sender.getName());
        Bukkit.getOnlinePlayers().parallelStream().forEach(onlinePlayer -> {
            UUID playerUUID = onlinePlayer.getUniqueId();
            PlayerConfig playerConfig = this.plugin.getPlayerConfig(playerUUID);
            playerConfig.setAutoTreeChopEnabled(autoTreeChopEnabled);
            AutoTreeChop.sendMessage((CommandSender)onlinePlayer, message);
        });
    }
}

