/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.tinytranslations;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.TreeSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.milkteamc.autotreechop.libs.tinytranslations.Message;
import org.milkteamc.autotreechop.libs.tinytranslations.MessageTranslator;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.key.Key;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.Component;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.TranslatableComponent;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.translation.GlobalTranslator;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.translation.Translator;

@ApiStatus.Internal
public class AdventureTranslatorAdapter
implements Translator {
    private static final AdventureTranslatorAdapter INSTANCE = new AdventureTranslatorAdapter();
    private static final Key KEY = Key.key("tinytranslations");
    private final Collection<MessageTranslator> translators = new HashSet<MessageTranslator>();

    public static AdventureTranslatorAdapter instance() {
        return INSTANCE;
    }

    public void register(MessageTranslator translator) {
        if (this.translators.add(translator) && this.translators.size() == 1) {
            GlobalTranslator.translator().addSource(this);
        }
    }

    public void unregister(MessageTranslator translator) {
        if (this.translators.remove(translator) && this.translators.isEmpty()) {
            GlobalTranslator.translator().removeSource(this);
        }
    }

    @Override
    @NotNull
    public Key name() {
        return KEY;
    }

    @Override
    @Nullable
    public Component translate(@NotNull TranslatableComponent component, @NotNull Locale locale) {
        Message m2;
        if (this.translators.isEmpty()) {
            return null;
        }
        if (component instanceof Message && Objects.equals((m2 = (Message)component).getKey().key(), "__anonymous__")) {
            for (MessageTranslator translator2 : this.translators) {
                if (m2.getKey().namespace() != null && !translator2.getPath().equals(m2.getKey().namespace())) continue;
                return translator2.translate(component, locale);
            }
            return this.translators.iterator().next().translate(component, locale);
        }
        HashMap<MessageTranslator, Message> matched = null;
        for (MessageTranslator translator3 : this.translators) {
            Message m3 = translator3.getMessage(component.key());
            if (m3 == null) continue;
            if (matched == null) {
                matched = new HashMap<MessageTranslator, Message>();
            }
            matched.put(translator3, m3);
        }
        if (matched == null || matched.isEmpty()) {
            return null;
        }
        if (matched.size() == 1) {
            return ((MessageTranslator)matched.entrySet().iterator().next().getKey()).translate(component, locale);
        }
        if (!(component instanceof Message)) {
            return ((MessageTranslator)matched.entrySet().iterator().next().getKey()).translate(component, locale);
        }
        Message message = (Message)component;
        TreeSet scores = new TreeSet();
        HashSet<Message.PlaceholderDescription> descs = new HashSet<Message.PlaceholderDescription>(message.placeholderDescriptions());
        matched.forEach((translator, m) -> {
            int score = 0;
            for (Message.PlaceholderDescription d : m.placeholderDescriptions()) {
                if (!descs.contains(d)) {
                    --score;
                    continue;
                }
                ++score;
            }
            scores.add(new ScoredTranslator((MessageTranslator)translator, (Message)m, score));
        });
        if (!scores.isEmpty()) {
            return ((ScoredTranslator)scores.last()).translator().translate(component, locale);
        }
        return null;
    }

    @Override
    @Nullable
    public MessageFormat translate(@NotNull String key, @NotNull Locale locale) {
        return null;
    }

    public Collection<MessageTranslator> getTranslators() {
        return this.translators;
    }

    private record ScoredTranslator(MessageTranslator translator, Message message, int score) implements Comparable<ScoredTranslator>
    {
        @Override
        public int compareTo(@NotNull ScoredTranslator o) {
            return Integer.compare(this.score, o.score);
        }
    }
}

