/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.tinytranslations;

import java.util.List;
import java.util.Set;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.Component;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.MiniMessage;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.Tag;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.serializer.ComponentSerializer;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

public class MessageEncoding {
    private static final MiniMessage S_MM = MiniMessage.miniMessage();
    public static final MessageEncoding MINI_MESSAGE = new MessageEncoding("minimessage", (ComponentSerializer)S_MM){

        @Override
        public String wrap(String content) {
            return content;
        }
    };
    private static final GsonComponentSerializer S_GSON = GsonComponentSerializer.gson();
    public static final MessageEncoding NBT = new MessageEncoding(List.of("nbt", "json", "gson"), (ComponentSerializer<Component, ? extends Component, String>)S_GSON);
    private static final LegacyComponentSerializer S_LEGACY = LegacyComponentSerializer.legacySection();
    private static final LegacyComponentSerializer S_LEGACY_AMP = LegacyComponentSerializer.legacyAmpersand();
    private static final PlainTextComponentSerializer S_PLAIN = PlainTextComponentSerializer.plainText();
    public static final MessageEncoding PLAIN = new MessageEncoding(List.of("plain", "pre"), (ComponentSerializer<Component, ? extends Component, String>)S_PLAIN);
    private static final TagResolver LEGACY_RESOLVER = TagResolver.resolver("legacy", (argumentQueue, context) -> {
        if (!argumentQueue.hasNext()) {
            return Tag.preProcessParsed("");
        }
        int symbol = 38;
        String content = argumentQueue.pop().value();
        if (argumentQueue.hasNext()) {
            symbol = content.toCharArray()[0];
            content = argumentQueue.pop().value();
        }
        LegacyComponentSerializer translator = null;
        if (symbol == 38) {
            translator = S_LEGACY_AMP;
        } else if (symbol == 167) {
            translator = S_LEGACY;
        }
        if (translator == null) {
            return Tag.preProcessParsed("");
        }
        return Tag.inserting(translator.deserialize(content));
    });
    public static final MessageEncoding LEGACY_PARAGRAPH = new MessageEncoding("legacy", (ComponentSerializer)S_LEGACY, LEGACY_RESOLVER){

        @Override
        public String wrap(String content) {
            return "<legacy:'\u00a7'>" + content + "</legacy>";
        }
    };
    public static final MessageEncoding LEGACY_AMPERSAND = new MessageEncoding("legacy", (ComponentSerializer)S_LEGACY_AMP, LEGACY_RESOLVER){

        @Override
        public String wrap(String content) {
            return "<legacy:'&'>" + content + "</legacy>";
        }
    };
    private static final MessageEncoding[] VALUES = new MessageEncoding[]{MINI_MESSAGE, NBT, LEGACY_PARAGRAPH, LEGACY_AMPERSAND, PLAIN};
    final List<String> tag;
    final TagResolver resolver;
    final ComponentSerializer<Component, ? extends Component, String> translator;

    MessageEncoding(String tag, ComponentSerializer<Component, ? extends Component, String> translator) {
        this(List.of(tag), translator);
    }

    MessageEncoding(List<String> tag, ComponentSerializer<Component, ? extends Component, String> translator) {
        this(tag, translator, TagResolver.resolver(Set.copyOf(tag), (argumentQueue, context) -> {
            if (!argumentQueue.hasNext()) {
                return Tag.preProcessParsed("");
            }
            String content = argumentQueue.pop().value();
            return Tag.inserting(translator.deserialize(content));
        }));
    }

    MessageEncoding(String tag, ComponentSerializer<Component, ? extends Component, String> translator, TagResolver resolver) {
        this(List.of(tag), translator, resolver);
    }

    MessageEncoding(List<String> tag, ComponentSerializer<Component, ? extends Component, String> translator, TagResolver resolver) {
        this.tag = tag;
        this.translator = translator;
        this.resolver = resolver;
    }

    public static MessageEncoding[] values() {
        return VALUES;
    }

    public String wrap(String content) {
        return "<" + this.tag + ">" + content + "</" + this.tag + ">";
    }

    public String format(Component component) {
        return this.translator.serialize(component);
    }

    public TagResolver getTagResolver() {
        return this.resolver;
    }
}

