/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.tinytranslations.nanomessage;

import java.util.ArrayList;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.Component;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.TextComponent;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.TextReplacementConfig;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.Tag;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

public final class DefaultResolvers {
    private static final PlainTextComponentSerializer PLAIN = PlainTextComponentSerializer.plainText();
    private static final Pattern URL_PATTERN = Pattern.compile("(https?://)?[^:/]+/(.+)");

    public static TagResolver choice(String key) {
        return TagResolver.resolver(key, (argumentQueue, context) -> {
            int input;
            TreeMap<Integer, Component> choice;
            block6: {
                String placeholder = argumentQueue.popOr("Placeholder required for choice element").value();
                Component parsedPlaceholder = context.deserialize(placeholder);
                String val = PLAIN.serialize(parsedPlaceholder);
                choice = new TreeMap<Integer, Component>();
                String zero = "";
                String one = "";
                String two = "";
                choice.put(2, Component.empty());
                if (argumentQueue.hasNext()) {
                    one = argumentQueue.pop().value();
                    choice.put(1, context.deserialize(one));
                }
                if (argumentQueue.hasNext()) {
                    two = argumentQueue.pop().value();
                    choice.put(2, context.deserialize(two));
                }
                if (argumentQueue.hasNext()) {
                    String t = argumentQueue.pop().value();
                    zero = one;
                    one = two;
                    two = t;
                    choice.put(0, context.deserialize(zero));
                    choice.put(1, context.deserialize(one));
                    choice.put(2, context.deserialize(two));
                    int i = 3;
                    while (argumentQueue.hasNext()) {
                        choice.put(i++, context.deserialize(argumentQueue.pop().value()));
                    }
                }
                input = 1;
                try {
                    input = Integer.parseInt(val);
                }
                catch (Throwable t) {
                    if (!val.equalsIgnoreCase("false")) break block6;
                    input = 0;
                }
            }
            return Tag.inserting(choice.getOrDefault(input, (Component)choice.lastEntry().getValue()));
        });
    }

    public static TagResolver repeat(String key) {
        return TagResolver.resolver(key, (argumentQueue, context) -> {
            int count = argumentQueue.hasNext() ? argumentQueue.pop().asInt().orElse(2) : 2;
            return (current, depth) -> {
                if (depth > 0) {
                    return Component.empty();
                }
                Component c = Component.empty();
                for (int i = 0; i < count; ++i) {
                    c = c.append(current);
                }
                return c;
            };
        });
    }

    public static TagResolver reverse(String key) {
        return TagResolver.resolver(key, (current, depth) -> {
            if (depth > 0) {
                return Component.empty();
            }
            return DefaultResolvers.reverse(current);
        });
    }

    private static Component reverse(Component c) {
        if (c instanceof TextComponent) {
            TextComponent tc = (TextComponent)c;
            c = tc.content(new StringBuilder(tc.content()).reverse().toString());
        }
        if (c.children().isEmpty()) {
            return c;
        }
        Component root = Component.empty().style(c.style());
        int size = c.children().size();
        for (int i = 0; i < size; ++i) {
            root = root.append(DefaultResolvers.reverse(c.children().get(size - i - 1)));
        }
        return root.append(c.children(new ArrayList()));
    }

    public static TagResolver shortUrl(String key) {
        return TagResolver.resolver(key, (argumentQueue, context) -> {
            int a = argumentQueue.hasNext() ? argumentQueue.pop().asInt().orElse(3) : 3;
            int b = argumentQueue.hasNext() ? argumentQueue.pop().asInt().orElse(3) : 3;
            return DefaultResolvers.shortURLTag(a, b);
        });
    }

    public static Tag shortURLTag(int a, int b) {
        if (a < 0 || b < 0) {
            throw new IllegalArgumentException("a and b must be greater or equals than 0. a=" + a + ", b=" + b);
        }
        return (current, depth) -> {
            if (depth > 0) {
                return Component.empty();
            }
            String content = PLAIN.serialize(current);
            Matcher matcher = URL_PATTERN.matcher(content);
            if (!matcher.matches()) {
                return current;
            }
            String tail = matcher.group(2);
            int tailLen = tail.length();
            if (a > tailLen || b > tailLen || a + b > tailLen) {
                return current;
            }
            return current.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(tail).replacement(tail.substring(0, a) + "..." + tail.substring(tail.length() - b)).build());
        };
    }

    public static TagResolver preview(String key) {
        return TagResolver.resolver(key, (argumentQueue, context) -> {
            int length = argumentQueue.hasNext() ? argumentQueue.pop().asInt().orElse(20) : 20;
            return DefaultResolvers.previewTag(length);
        });
    }

    public static Tag previewTag(int length) {
        AtomicInteger dots = new AtomicInteger();
        return (current, depth) -> DefaultResolvers.mapChildren(current, c -> DefaultResolvers.modifyText(c, s -> {
            String result = s;
            if (s.length() + dots.get() > length - 3) {
                result = s.substring(0, Integer.min(s.length(), Integer.max(0, length - dots.get())));
            }
            dots.addAndGet(s.length());
            return result;
        }));
    }

    public static TagResolver lower(String key) {
        return TagResolver.resolver(key, DefaultResolvers.lowerTag());
    }

    public static TagResolver upper(String key) {
        return TagResolver.resolver(key, DefaultResolvers.upperTag());
    }

    public static Tag lowerTag() {
        return (current, depth) -> DefaultResolvers.modifyText(current, String::toLowerCase).children(new ArrayList());
    }

    public static Tag upperTag() {
        return (current, depth) -> DefaultResolvers.modifyText(current, String::toUpperCase).children(new ArrayList());
    }

    private static Component mapChildren(Component c, Function<Component, Component> consumer) {
        return Component.empty().children(c.children().stream().map(consumer).toList());
    }

    private static Component modifyText(Component c, Function<String, String> modifier) {
        Component component;
        if ((c = c.children(c.children().stream().map(comp -> DefaultResolvers.modifyText(comp, modifier)).toList())) instanceof TextComponent) {
            TextComponent tc = (TextComponent)c;
            component = tc.content(modifier.apply(tc.content()));
        } else {
            component = c;
        }
        return component;
    }

    private DefaultResolvers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

