/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.tinytranslations.tinyobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.TinyDefault;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.TinyObject;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.TinyObjectMapping;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.TinyObjectResolver;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.TinyProperty;

public class TinyObjectResolverImpl
implements TinyObjectResolver {
    @Override
    @Nullable
    public Object resolveObject(@NotNull Object object, Iterable<String> path, Collection<TinyObjectMapping> mappings) {
        LinkedList<String> queue = new LinkedList<String>();
        path.iterator().forEachRemaining(queue::add);
        return this.resolve(object, queue, mappings);
    }

    @Nullable
    private Object resolve(@Nullable Object obj, Queue<String> path, Collection<TinyObjectMapping> mappings) {
        ArrayList<TinyObjectMapping> m = new ArrayList<TinyObjectMapping>(new LinkedHashSet<TinyObjectMapping>(mappings));
        Collections.reverse(m);
        while (obj != null) {
            if (Arrays.stream(obj.getClass().getAnnotations()).anyMatch(annotation -> annotation.annotationType().equals(TinyObject.class))) {
                TinyObjectMapping.Builder<?> builder = TinyObjectMapping.builder(obj.getClass());
                for (Field f : obj.getClass().getDeclaredFields()) {
                    for (Annotation annotation2 : f.getAnnotations()) {
                        if (annotation2.annotationType().equals(TinyProperty.class)) {
                            String name = Objects.equals(((TinyProperty)annotation2).name(), "$") ? f.getName().toLowerCase() : ((TinyProperty)annotation2).name();
                            builder.with(name, o -> this.getFieldValue(f, o));
                            continue;
                        }
                        if (!annotation2.annotationType().equals(TinyDefault.class)) continue;
                        builder.withFallbackConversion(o -> this.getFieldValue(f, o));
                    }
                }
                m.add(builder.build());
            }
            boolean noneMatch = true;
            for (TinyObjectMapping mapping : m) {
                if (!mapping.matches(obj)) continue;
                if (path.isEmpty()) {
                    obj = mapping.resolve(obj);
                    noneMatch = false;
                    break;
                }
                if (!mapping.containsKey(path.peek())) continue;
                obj = mapping.resolve(obj, path.poll());
                noneMatch = false;
                break;
            }
            if (!noneMatch) continue;
            if (path.isEmpty()) break;
            return null;
        }
        return obj;
    }

    private Object getFieldValue(Field field, Object obj) {
        try {
            if (!field.canAccess(obj)) {
                field.setAccessible(true);
            }
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

