/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.milkteamc.autotreechop.AutoTreeChop;
import org.milkteamc.autotreechop.Config;
import org.milkteamc.autotreechop.PlayerConfig;
import org.milkteamc.autotreechop.utils.AsyncTaskScheduler;
import org.milkteamc.autotreechop.utils.BatchProcessor;
import org.milkteamc.autotreechop.utils.BlockDiscoveryUtils;
import org.milkteamc.autotreechop.utils.LeafRemovalUtils;
import org.milkteamc.autotreechop.utils.PermissionUtils;
import org.milkteamc.autotreechop.utils.ProtectionCheckUtils;
import org.milkteamc.autotreechop.utils.SessionManager;
import org.milkteamc.autotreechop.utils.TreeReplantUtils;

public class TreeChopUtils {
    private static final Random random = new Random();
    private final AutoTreeChop plugin;
    private final AsyncTaskScheduler scheduler;
    private final BatchProcessor batchProcessor;
    private final SessionManager sessionManager;

    public TreeChopUtils(AutoTreeChop plugin) {
        this.plugin = plugin;
        this.scheduler = new AsyncTaskScheduler(plugin);
        this.batchProcessor = new BatchProcessor(plugin, this.scheduler);
        this.sessionManager = SessionManager.getInstance();
    }

    public void chopTree(Block block, Player player, boolean connectedBlocks, ItemStack tool, Location location, Config config, PlayerConfig playerConfig, ProtectionCheckUtils.ProtectionHooks hooks) {
        if (!ProtectionCheckUtils.canModifyBlock(player, location, hooks)) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        if (this.sessionManager.isLocationProcessing(playerUUID, block.getLocation())) {
            return;
        }
        if (!BlockDiscoveryUtils.isLog(block.getType(), config)) {
            return;
        }
        if (config.getMustUseTool() && !TreeChopUtils.isTool(player)) {
            return;
        }
        Runnable discoveryTask = () -> {
            Set<Location> treeBlocks = BlockDiscoveryUtils.discoverTreeBFS(block, config, connectedBlocks, player, hooks);
            Runnable validationTask = () -> this.validateAndExecuteChop(treeBlocks, block, player, tool, config, playerConfig, hooks);
            this.scheduler.runTask(location, validationTask);
        };
        this.sessionManager.addTreeChopLocations(playerUUID, Collections.singleton(block.getLocation()));
        this.scheduler.runTaskAsync(config, discoveryTask);
    }

    private void validateAndExecuteChop(Set<Location> treeBlocks, Block originalBlock, Player player, ItemStack tool, Config config, PlayerConfig playerConfig, ProtectionCheckUtils.ProtectionHooks hooks) {
        UUID playerUUID = player.getUniqueId();
        if (treeBlocks.isEmpty()) {
            this.sessionManager.clearTreeChopSession(playerUUID);
            return;
        }
        if (treeBlocks.size() > config.getMaxTreeSize()) {
            AutoTreeChop.sendMessage((CommandSender)player, AutoTreeChop.HIT_MAX_BLOCK_MESSAGE);
            this.sessionManager.clearTreeChopSession(playerUUID);
            return;
        }
        if (!PermissionUtils.hasVipBlock(player, playerConfig, config) && playerConfig.getDailyBlocksBroken() + treeBlocks.size() > config.getMaxBlocksPerDay()) {
            AutoTreeChop.sendMessage((CommandSender)player, AutoTreeChop.HIT_MAX_BLOCK_MESSAGE);
            this.sessionManager.clearTreeChopSession(playerUUID);
            return;
        }
        if (config.isToolDamage() && !TreeChopUtils.hasEnoughDurability(tool, treeBlocks.size(), config)) {
            this.sessionManager.clearTreeChopSession(playerUUID);
            return;
        }
        playerConfig.incrementDailyUses();
        this.sessionManager.addTreeChopLocations(playerUUID, treeBlocks);
        this.executeTreeChop(treeBlocks, player, tool, config, playerConfig, hooks, originalBlock);
    }

    private void executeTreeChop(Set<Location> treeBlocks, Player player, ItemStack tool, Config config, PlayerConfig playerConfig, ProtectionCheckUtils.ProtectionHooks hooks, Block originalBlock) {
        ArrayList<Location> blockList = new ArrayList<Location>(treeBlocks);
        int batchSize = BatchProcessor.getOptimalBatchSize(blockList.size(), config.getChopBatchSize());
        int totalBlocks = blockList.size();
        UUID playerUUID = player.getUniqueId();
        HashMap logTypesForReplant = new HashMap();
        this.batchProcessor.processBatch(blockList, 0, batchSize, (location, index) -> {
            Block block = location.getBlock();
            if (!BlockDiscoveryUtils.isLog(block.getType(), config)) {
                return;
            }
            Material originalLogType = block.getType();
            logTypesForReplant.putIfAbsent(originalLogType, location);
            if (config.isCallBlockBreakEvent()) {
                BlockBreakEvent breakEvent = new BlockBreakEvent(block, player);
                this.plugin.getServer().getPluginManager().callEvent((Event)breakEvent);
                if (breakEvent.isCancelled()) {
                    return;
                }
            }
            if (config.getPlayBreakSound()) {
                block.getWorld().playSound(location, Sound.BLOCK_WOOD_BREAK, 1.0f, 1.0f);
            }
            block.breakNaturally();
            this.sessionManager.trackRemovedLogForPlayer(playerUUID.toString(), (Location)location);
            playerConfig.incrementDailyBlocksBroken();
        }, () -> {
            if (config.isToolDamage()) {
                TreeChopUtils.applyToolDamage(tool, player, totalBlocks, config);
            }
            if (config.isLeafRemovalEnabled()) {
                long delay = config.getLeafRemovalDelayTicks();
                Runnable leafTask = () -> {
                    LeafRemovalUtils leafUtils = new LeafRemovalUtils(this.plugin);
                    leafUtils.processLeafRemoval(originalBlock, player, config, playerConfig, hooks);
                };
                if (delay > 0L) {
                    this.scheduler.runTaskLater(originalBlock.getLocation(), leafTask, delay);
                } else {
                    leafTask.run();
                }
            }
            if (TreeReplantUtils.isReplantEnabledForPlayer(player, config)) {
                for (Map.Entry entry : logTypesForReplant.entrySet()) {
                    Block blockToReplant = ((Location)entry.getValue()).getBlock();
                    TreeReplantUtils.scheduleReplant(player, blockToReplant, (Material)entry.getKey(), this.plugin, config, hooks.worldGuardEnabled, hooks.residenceEnabled, hooks.griefPreventionEnabled, hooks.landsEnabled, hooks.lands, hooks.residence, hooks.griefPrevention, hooks.worldGuard);
                }
            }
            this.plugin.getCooldownManager().setCooldown(player, playerUUID, config);
            this.sessionManager.removeTreeChopLocations(playerUUID, blockList);
        });
    }

    private static boolean hasEnoughDurability(ItemStack tool, int blockCount, Config config) {
        if (tool == null || tool.getType().getMaxDurability() <= 0) {
            return true;
        }
        ItemMeta itemMeta = tool.getItemMeta();
        if (!(itemMeta instanceof Damageable)) {
            return true;
        }
        Damageable damageableMeta = (Damageable)itemMeta;
        int currentDamage = damageableMeta.getDamage();
        short maxDurability = tool.getType().getMaxDurability();
        int remainingDurability = maxDurability - currentDamage;
        int unbreakingLevel = TreeChopUtils.getUnbreakingLevel(tool);
        int estimatedDamage = config.getRespectUnbreaking() && unbreakingLevel > 0 ? blockCount / (unbreakingLevel + 1) : blockCount * config.getToolDamageDecrease();
        return remainingDurability > estimatedDamage;
    }

    private static void applyToolDamage(ItemStack tool, Player player, int blocksBroken, Config config) {
        if (tool == null || tool.getType().getMaxDurability() <= 0) {
            return;
        }
        ItemMeta itemMeta = tool.getItemMeta();
        if (!(itemMeta instanceof Damageable)) {
            return;
        }
        Damageable damageableMeta = (Damageable)itemMeta;
        int unbreakingLevel = TreeChopUtils.getUnbreakingLevel(tool);
        int damageToApply = 0;
        for (int i = 0; i < blocksBroken * config.getToolDamageDecrease(); ++i) {
            if (!TreeChopUtils.shouldApplyDurabilityLoss(unbreakingLevel, config)) continue;
            ++damageToApply;
        }
        int currentDamage = damageableMeta.getDamage();
        int newDamage = currentDamage + damageToApply;
        if (newDamage >= tool.getType().getMaxDurability()) {
            player.getInventory().removeItem(new ItemStack[]{tool});
        } else {
            damageableMeta.setDamage(newDamage);
            tool.setItemMeta((ItemMeta)damageableMeta);
        }
    }

    private static int getUnbreakingLevel(ItemStack item) {
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasEnchants()) {
            return item.getEnchantmentLevel(Enchantment.DURABILITY);
        }
        return 0;
    }

    private static boolean shouldApplyDurabilityLoss(int unbreakingLevel, Config config) {
        if (unbreakingLevel <= 0 || !config.getRespectUnbreaking()) {
            return true;
        }
        return (double)random.nextInt(100) < 100.0 / (double)(unbreakingLevel + 1);
    }

    public static boolean isTool(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        String materialName = item.getType().toString();
        return materialName.endsWith("_AXE") || materialName.endsWith("_HOE") || materialName.endsWith("_PICKAXE") || materialName.endsWith("_SHOVEL") || materialName.endsWith("_SWORD") || item.getType() == Material.SHEARS || item.getType() == Material.FISHING_ROD || item.getType() == Material.FLINT_AND_STEEL;
    }
}

