/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop;

import java.io.File;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.milkteamc.autotreechop.AutoTreeChopAPI;
import org.milkteamc.autotreechop.AutoTreeChopExpansion;
import org.milkteamc.autotreechop.Config;
import org.milkteamc.autotreechop.Metrics;
import org.milkteamc.autotreechop.ModrinthUpdateChecker;
import org.milkteamc.autotreechop.PlayerConfig;
import org.milkteamc.autotreechop.command.Command;
import org.milkteamc.autotreechop.command.TabCompleter;
import org.milkteamc.autotreechop.database.DatabaseManager;
import org.milkteamc.autotreechop.events.BlockBreakListener;
import org.milkteamc.autotreechop.events.PlayerJoinListener;
import org.milkteamc.autotreechop.events.PlayerQuitListener;
import org.milkteamc.autotreechop.events.PlayerSneakListener;
import org.milkteamc.autotreechop.hooks.GriefPreventionHook;
import org.milkteamc.autotreechop.hooks.LandsHook;
import org.milkteamc.autotreechop.hooks.ResidenceHook;
import org.milkteamc.autotreechop.hooks.WorldGuardHook;
import org.milkteamc.autotreechop.libs.tinytranslations.BukkitTinyTranslations;
import org.milkteamc.autotreechop.libs.tinytranslations.GlobalMessages;
import org.milkteamc.autotreechop.libs.tinytranslations.Message;
import org.milkteamc.autotreechop.libs.tinytranslations.MessageBuilder;
import org.milkteamc.autotreechop.libs.tinytranslations.MessageTranslator;
import org.milkteamc.autotreechop.libs.tinytranslations.TinyTranslations;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.ComponentLike;
import org.milkteamc.autotreechop.libs.tinytranslations.storage.properties.PropertiesMessageStorage;
import org.milkteamc.autotreechop.libs.tinytranslations.storage.properties.PropertiesStyleStorage;
import org.milkteamc.autotreechop.tasks.PlayerDataSaveTask;
import org.milkteamc.autotreechop.utils.CooldownManager;
import org.milkteamc.autotreechop.utils.SessionManager;
import org.milkteamc.autotreechop.utils.TreeChopUtils;

public class AutoTreeChop
extends JavaPlugin
implements CommandExecutor {
    public static final Message noResidencePermissions = new MessageBuilder("noResidencePermissions").withDefault("<prefix_negative>You don't have permission to use AutoTreeChop here.</prefix_negative>").build();
    public static final Message ENABLED_MESSAGE = new MessageBuilder("enabled").withDefault("<prefix>Auto tree chopping enabled.</prefix>").build();
    public static final Message DISABLED_MESSAGE = new MessageBuilder("disabled").withDefault("<prefix_negative>Auto tree chopping disabled.</prefix_negative>").build();
    public static final Message NO_PERMISSION_MESSAGE = new MessageBuilder("no-permission").withDefault(GlobalMessages.NO_PERM_CMD).build();
    public static final Message ONLY_PLAYERS_MESSAGE = new MessageBuilder("only-players").withDefault(GlobalMessages.CMD_PLAYER_ONLY).build();
    public static final Message HIT_MAX_USAGE_MESSAGE = new MessageBuilder("hitmaxusage").withDefault("<prefix_negative>You've reached the daily usage limit.</prefix_negative>").build();
    public static final Message HIT_MAX_BLOCK_MESSAGE = new MessageBuilder("hitmaxblock").withDefault("<prefix_negative>You have reached your daily block breaking limit.</prefix_negative>").build();
    public static final Message USAGE_MESSAGE = new MessageBuilder("usage").withDefault("<prefix>You have used the AutoTreeChop {current_uses}/{max_uses} times today.</prefix>").build();
    public static final Message BLOCKS_BROKEN_MESSAGE = new MessageBuilder("blocks-broken").withDefault("<prefix>You have broken {current_blocks}/{max_blocks} blocks today.</prefix>").build();
    public static final Message ENABLED_BY_OTHER_MESSAGE = new MessageBuilder("enabledByOther").withDefault("<prefix>Auto tree chopping enabled by {player}.</prefix>").build();
    public static final Message ENABLED_FOR_OTHER_MESSAGE = new MessageBuilder("enabledForOther").withDefault("<prefix>Auto tree chopping enabled for {player}</prefix>").build();
    public static final Message DISABLED_BY_OTHER_MESSAGE = new MessageBuilder("disabledByOther").withDefault("<prefix_negative>Auto tree chopping disabled by {player}.</prefix_negative>").build();
    public static final Message DISABLED_FOR_OTHER_MESSAGE = new MessageBuilder("disabledForOther").withDefault("<prefix_negative>Auto tree chopping disabled for {player}</prefix_negative>").build();
    public static final Message STILL_IN_COOLDOWN_MESSAGE = new MessageBuilder("stillInCooldown").withDefault("<prefix_negative>You are still in cooldown! Try again after {cooldown_time} seconds.</prefix_negative>").build();
    public static final Message CONSOLE_NAME = new MessageBuilder("consoleName").withDefault("console").build();
    public static final Message SNEAK_ENABLED_MESSAGE = new MessageBuilder("sneakEnabled").withDefault("<prefix>Auto tree chopping enabled by sneaking.</prefix>").build();
    public static final Message SNEAK_DISABLED_MESSAGE = new MessageBuilder("sneakDisabled").withDefault("<prefix_negative>Auto tree chopping disabled by stopping sneak.</prefix_negative>").build();
    private static final long SAVE_INTERVAL = 1200L;
    private static final int SAVE_THRESHOLD = 15;
    private Config config;
    private AutoTreeChopAPI autoTreeChopAPI;
    private Map<UUID, PlayerConfig> playerConfigs = new ConcurrentHashMap<UUID, PlayerConfig>();
    private Metrics metrics;
    private MessageTranslator translations;
    private boolean worldGuardEnabled = false;
    private boolean residenceEnabled = false;
    private boolean griefPreventionEnabled = false;
    private boolean landsEnabled = false;
    private WorldGuardHook worldGuardHook = null;
    private ResidenceHook residenceHook = null;
    private GriefPreventionHook griefPreventionHook = null;
    private LandsHook landsHook = null;
    private CooldownManager cooldownManager;
    private DatabaseManager databaseManager;
    private PlayerDataSaveTask saveTask;
    private TreeChopUtils treeChopUtils;

    public static void sendMessage(CommandSender sender, ComponentLike message) {
        BukkitTinyTranslations.sendMessageIfNotEmpty(sender, message);
    }

    public static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = new Config(this);
        this.metrics = new Metrics((Plugin)this, 20053);
        this.registerEvents();
        Command command = new Command(this);
        Objects.requireNonNull(this.getCommand("autotreechop")).setExecutor((CommandExecutor)command);
        Objects.requireNonNull(this.getCommand("atc")).setExecutor((CommandExecutor)command);
        Objects.requireNonNull(this.getCommand("autotreechop")).setTabCompleter((org.bukkit.command.TabCompleter)new TabCompleter());
        Objects.requireNonNull(this.getCommand("atc")).setTabCompleter((org.bukkit.command.TabCompleter)new TabCompleter());
        this.translations = BukkitTinyTranslations.application((Plugin)this);
        this.translations.setMessageStorage(new PropertiesMessageStorage(new File(this.getDataFolder(), "/lang/")));
        this.translations.setStyleStorage(new PropertiesStyleStorage(new File(this.getDataFolder(), "/lang/styles.properties")));
        this.translations.addMessages(TinyTranslations.messageFieldsFromClass(AutoTreeChop.class));
        this.loadLocale();
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new AutoTreeChopExpansion(this).register();
            this.getLogger().info("PlaceholderAPI expansion for AutoTreeChop has been registered.");
        } else {
            this.getLogger().warning("PlaceholderAPI not found. Placeholder expansion for AutoTreeChop will not work.");
        }
        new ModrinthUpdateChecker(this, "autotreechop", "paper").checkEveryXHours(24).setDonationLink("https://ko-fi.com/maoyue").setChangelogLink("https://modrinth.com/plugin/autotreechop/version/latest").setDownloadLink("https://modrinth.com/plugin/autotreechop/version/latest").setNotifyOpsOnJoin(true).setNotifyByPermissionOnJoin("autotreechop.updatechecker").checkNow();
        this.databaseManager = new DatabaseManager((Plugin)this, this.config.isUseMysql(), this.config.getHostname(), this.config.getPort(), this.config.getDatabase(), this.config.getUsername(), this.config.getPassword());
        this.saveTask = new PlayerDataSaveTask(this, 15);
        this.saveTask.runTaskTimerAsynchronously((Plugin)this, 1200L, 1200L);
        this.autoTreeChopAPI = new AutoTreeChopAPI(this);
        this.playerConfigs = new ConcurrentHashMap<UUID, PlayerConfig>();
        this.initializeHooks();
        this.cooldownManager = new CooldownManager(this);
        this.treeChopUtils = new TreeChopUtils(this);
        this.getLogger().info("AutoTreeChop enabled!");
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerSneakListener(this), (Plugin)this);
    }

    private void initializeHooks() {
        if (Bukkit.getPluginManager().getPlugin("Residence") != null) {
            try {
                this.residenceHook = new ResidenceHook(this.config.getResidenceFlag());
                this.residenceEnabled = true;
                this.getLogger().info("Residence support enabled");
            }
            catch (Exception e) {
                this.getLogger().warning("Residence can't be hook, please report this to our GitHub: https://github.com/milkteamc/AutoTreeChop/issues");
                this.residenceEnabled = false;
            }
        } else {
            this.residenceEnabled = false;
        }
        if (Bukkit.getPluginManager().getPlugin("GriefPrevention") != null) {
            try {
                this.griefPreventionHook = new GriefPreventionHook(this.config.getGriefPreventionFlag());
                this.griefPreventionEnabled = true;
                this.getLogger().info("GriefPrevention support enabled");
            }
            catch (Exception e) {
                this.getLogger().warning("GriefPrevention can't be hook, please report this to our GitHub: https://github.com/milkteamc/AutoTreeChop/issues");
                this.griefPreventionEnabled = false;
            }
        } else {
            this.griefPreventionEnabled = false;
        }
        if (Bukkit.getPluginManager().getPlugin("Lands") != null) {
            try {
                this.landsHook = new LandsHook((Plugin)this);
                this.landsEnabled = true;
                this.getLogger().info("Lands support enabled");
            }
            catch (Exception e) {
                this.getLogger().warning("Lands can't be hook, please report this to our GitHub: https://github.com/milkteamc/AutoTreeChop/issues");
                this.landsEnabled = false;
            }
        } else {
            this.landsEnabled = false;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            try {
                this.worldGuardHook = new WorldGuardHook();
                this.worldGuardEnabled = true;
                this.getLogger().info("WorldGuard support enabled");
            }
            catch (NoClassDefFoundError e) {
                this.getLogger().warning("WorldGuard can't be hook, please report this to our GitHub: https://github.com/milkteamc/AutoTreeChop/issues");
                this.worldGuardEnabled = false;
            }
        } else {
            this.worldGuardEnabled = false;
        }
    }

    private void loadLocale() {
        this.saveResourceIfNotExists("lang/styles.properties");
        this.saveResourceIfNotExists("lang/de.properties");
        this.saveResourceIfNotExists("lang/es.properties");
        this.saveResourceIfNotExists("lang/fr.properties");
        this.saveResourceIfNotExists("lang/ja.properties");
        this.saveResourceIfNotExists("lang/ru.properties");
        this.saveResourceIfNotExists("lang/zh.properties");
        this.translations.setUseClientLocale(this.config.isUseClientLocale());
        this.translations.defaultLocale(this.config.getLocale() == null ? Locale.getDefault() : this.config.getLocale());
        this.translations.loadStyles();
        this.translations.loadLocales();
    }

    private void saveResourceIfNotExists(String resourcePath) {
        if (!new File(this.getDataFolder(), resourcePath).exists()) {
            this.saveResource(resourcePath, false);
        }
    }

    public void onDisable() {
        this.getLogger().info("Saving all player data before shutdown...");
        if (this.saveTask != null) {
            this.saveTask.cancel();
        }
        for (Map.Entry<UUID, PlayerConfig> entry : this.playerConfigs.entrySet()) {
            if (!entry.getValue().isDirty()) continue;
            this.databaseManager.savePlayerDataSync(entry.getValue().getData());
        }
        this.playerConfigs.clear();
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        SessionManager sessionManager = SessionManager.getInstance();
        for (UUID uuid : new HashSet<UUID>(this.playerConfigs.keySet())) {
            sessionManager.clearAllPlayerSessions(uuid);
        }
        this.translations.close();
        this.metrics.shutdown();
        this.getLogger().info("AutoTreeChop disabled!");
    }

    public PlayerConfig getPlayerConfig(UUID playerUUID) {
        PlayerConfig playerConfig = this.playerConfigs.get(playerUUID);
        if (playerConfig == null) {
            this.getLogger().warning("PlayerConfig not found for " + String.valueOf(playerUUID) + ", loading synchronously");
            try {
                DatabaseManager.PlayerData data = this.databaseManager.loadPlayerDataAsync(playerUUID, this.config.getDefaultTreeChop()).get();
                playerConfig = new PlayerConfig(playerUUID, data);
                this.playerConfigs.put(playerUUID, playerConfig);
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to load player data: " + e.getMessage());
                DatabaseManager.PlayerData defaultData = new DatabaseManager.PlayerData(playerUUID, this.config.getDefaultTreeChop(), 0, 0, LocalDate.now());
                playerConfig = new PlayerConfig(playerUUID, defaultData);
                this.playerConfigs.put(playerUUID, playerConfig);
            }
        }
        return playerConfig;
    }

    public int getPlayerDailyUses(UUID playerUUID) {
        return this.getPlayerConfig(playerUUID).getDailyUses();
    }

    public int getPlayerDailyBlocksBroken(UUID playerUUID) {
        return this.getPlayerConfig(playerUUID).getDailyBlocksBroken();
    }

    public AutoTreeChopAPI getAutoTreeChopAPI() {
        return this.autoTreeChopAPI;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public Config getPluginConfig() {
        return this.config;
    }

    public Map<UUID, PlayerConfig> getAllPlayerConfigs() {
        return this.playerConfigs;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public TreeChopUtils getTreeChopUtils() {
        return this.treeChopUtils;
    }

    public boolean isWorldGuardEnabled() {
        return this.worldGuardEnabled;
    }

    public boolean isResidenceEnabled() {
        return this.residenceEnabled;
    }

    public boolean isGriefPreventionEnabled() {
        return this.griefPreventionEnabled;
    }

    public boolean isLandsEnabled() {
        return this.landsEnabled;
    }

    public WorldGuardHook getWorldGuardHook() {
        return this.worldGuardHook;
    }

    public ResidenceHook getResidenceHook() {
        return this.residenceHook;
    }

    public GriefPreventionHook getGriefPreventionHook() {
        return this.griefPreventionHook;
    }

    public LandsHook getLandsHook() {
        return this.landsHook;
    }
}

