/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.events;

import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.milkteamc.autotreechop.AutoTreeChop;
import org.milkteamc.autotreechop.PlayerConfig;

public class PlayerSneakListener
implements Listener {
    private final AutoTreeChop plugin;

    public PlayerSneakListener(AutoTreeChop plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        if (!this.plugin.getPluginConfig().getSneakToggle()) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (!player.hasPermission("autotreechop.use")) {
            return;
        }
        PlayerConfig playerConfig = this.plugin.getPlayerConfig(playerUUID);
        if (event.isSneaking()) {
            playerConfig.setAutoTreeChopEnabled(true);
            if (this.plugin.getPluginConfig().getSneakMessage()) {
                AutoTreeChop.sendMessage((CommandSender)player, AutoTreeChop.SNEAK_ENABLED_MESSAGE);
            }
        } else {
            playerConfig.setAutoTreeChopEnabled(false);
            if (this.plugin.getPluginConfig().getSneakMessage()) {
                AutoTreeChop.sendMessage((CommandSender)player, AutoTreeChop.SNEAK_DISABLED_MESSAGE);
            }
        }
    }
}

