/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.utils;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.bukkit.Location;
import org.milkteamc.autotreechop.AutoTreeChop;
import org.milkteamc.autotreechop.utils.AsyncTaskScheduler;

public class BatchProcessor {
    private final AutoTreeChop plugin;
    private final AsyncTaskScheduler scheduler;

    public BatchProcessor(AutoTreeChop plugin, AsyncTaskScheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
    }

    public void processBatch(List<Location> locations, int startIndex, int batchSize, BiConsumer<Location, Integer> processor, Runnable onComplete) {
        this.processBatchInternal(locations, startIndex, batchSize, processor, onComplete, 1L);
    }

    public void processBatchWithDelay(List<Location> locations, int startIndex, int batchSize, BiConsumer<Location, Integer> processor, Runnable onComplete, long delayTicks) {
        this.processBatchInternal(locations, startIndex, batchSize, processor, onComplete, delayTicks);
    }

    private void processBatchInternal(List<Location> locations, int startIndex, int batchSize, BiConsumer<Location, Integer> processor, Runnable onComplete, long delayTicks) {
        if (locations.isEmpty() || startIndex >= locations.size()) {
            if (onComplete != null) {
                onComplete.run();
            }
            return;
        }
        int endIndex = Math.min(startIndex + batchSize, locations.size());
        boolean isLastBatch = endIndex >= locations.size();
        for (int i = startIndex; i < endIndex; ++i) {
            Location location = locations.get(i);
            processor.accept(location, i);
        }
        if (isLastBatch) {
            if (onComplete != null) {
                onComplete.run();
            }
        } else {
            Location nextLocation = locations.get(endIndex);
            Runnable nextBatch = () -> this.processBatchInternal(locations, endIndex, batchSize, processor, onComplete, delayTicks);
            this.scheduler.runTaskLater(nextLocation, nextBatch, delayTicks);
        }
    }

    public void processBatchWithTermination(List<Location> locations, int startIndex, int batchSize, BiFunction<Location, Integer, Boolean> processor, Runnable onComplete) {
        boolean isLastBatch;
        int i;
        if (locations.isEmpty() || startIndex >= locations.size()) {
            if (onComplete != null) {
                onComplete.run();
            }
            return;
        }
        int endIndex = Math.min(startIndex + batchSize, locations.size());
        boolean shouldContinue = true;
        for (i = startIndex; i < endIndex && shouldContinue; ++i) {
            Location location = locations.get(i);
            shouldContinue = processor.apply(location, i);
        }
        boolean bl = isLastBatch = i >= locations.size();
        if (!shouldContinue || isLastBatch) {
            if (onComplete != null) {
                onComplete.run();
            }
        } else {
            Location nextLocation = locations.get(i);
            int finalI = i;
            Runnable nextBatch = () -> this.processBatchWithTermination(locations, finalI, batchSize, processor, onComplete);
            this.scheduler.runTaskLater(nextLocation, nextBatch, 1L);
        }
    }
}

