/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.tinytranslations;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.milkteamc.autotreechop.libs.tinytranslations.Formattable;
import org.milkteamc.autotreechop.libs.tinytranslations.MessageBuilder;
import org.milkteamc.autotreechop.libs.tinytranslations.MessageEncoding;
import org.milkteamc.autotreechop.libs.tinytranslations.TranslationKey;
import org.milkteamc.autotreechop.libs.tinytranslations.UnownedMessageImpl;
import org.milkteamc.autotreechop.libs.tinytranslations.annotation.KeyPattern;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.ComponentLike;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.TranslatableComponent;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.translation.Translatable;
import org.milkteamc.autotreechop.libs.tinytranslations.storage.Commented;

public interface Message
extends ComponentLike,
Cloneable,
Comparable<Message>,
Formattable<Message>,
Commented<Message>,
Translatable,
TranslatableComponent {
    public static final String TEMPORARY_MESSAGE_KEY = "__anonymous__";

    @Deprecated(forRemoval=true, since="4.5.2")
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public static Message contextual(@Language(value="NanoMessage") String content) {
        return Message.temporary(content);
    }

    public static Message temporary(@Language(value="NanoMessage") String content) {
        return new MessageBuilder(TEMPORARY_MESSAGE_KEY).withDefault(content).build();
    }

    public static Message unowned(String key) {
        return new UnownedMessageImpl(key);
    }

    @Deprecated(forRemoval=true, since="4.5.2")
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public static Message message(String key) {
        return Message.unowned(key);
    }

    public static Message unowned(String key, @Language(value="NanoMessage") String defaultValue) {
        return new MessageBuilder(key).withDefault(defaultValue).build();
    }

    @Deprecated(forRemoval=true, since="4.5.2")
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public static Message message(String key, @Language(value="NanoMessage") String defaultValue) {
        return Message.unowned(key, defaultValue);
    }

    public static MessageBuilder builder(@KeyPattern String key) {
        return new MessageBuilder(key);
    }

    public TranslationKey getKey();

    public String toString(MessageEncoding var1);

    public String toString(MessageEncoding var1, Locale var2);

    @Deprecated(forRemoval=true, since="4.5.0")
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public Map<Locale, String> getDictionary();

    @Deprecated(forRemoval=true, since="4.5.0")
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public Map<String, Optional<String>> getPlaceholderDescriptions();

    @Deprecated(forRemoval=true, since="4.5.0")
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public void setPlaceholderDescriptions(Map<String, Optional<String>> var1);

    @Deprecated(forRemoval=true, since="4.5.0")
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    @Nullable
    public String getComment();

    @Deprecated(forRemoval=true, since="4.5.0")
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public void setComment(@Nullable String var1);

    public Map<Locale, String> dictionary();

    @Contract(pure=true)
    public Message dictionary(Map<Locale, String> var1);

    @Contract(pure=true)
    default public Message dictionaryEntry(Locale locale, String translation) {
        HashMap<Locale, String> map = new HashMap<Locale, String>(this.dictionary());
        map.put(locale, translation);
        return this.dictionary(map);
    }

    public Collection<PlaceholderDescription> placeholderDescriptions();

    public Message placeholderDescriptions(Collection<PlaceholderDescription> var1);

    public record PlaceholderDescription(String[] names, @Nullable String description, Class<?> type) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlaceholderDescription that = (PlaceholderDescription)o;
            return Arrays.equals(this.names, that.names) && Objects.equals(this.description, that.description) && Objects.equals(this.type, that.type);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.description, this.type);
            result = 31 * result + Arrays.hashCode(this.names);
            return result;
        }
    }
}

