/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;
import org.milkteamc.autotreechop.AutoTreeChop;
import org.milkteamc.autotreechop.Config;
import org.milkteamc.autotreechop.PlayerConfig;
import org.milkteamc.autotreechop.hooks.GriefPreventionHook;
import org.milkteamc.autotreechop.hooks.LandsHook;
import org.milkteamc.autotreechop.hooks.ResidenceHook;
import org.milkteamc.autotreechop.hooks.WorldGuardHook;
import org.milkteamc.autotreechop.utils.EffectUtils;
import org.milkteamc.autotreechop.utils.PermissionUtils;
import org.milkteamc.autotreechop.utils.TreeChopUtils;

public class LeafRemovalUtils {
    private static final Map<String, Set<Location>> removedLogsPerSession = new HashMap<String, Set<Location>>();
    private static final Set<String> activeLeafRemovalSessions = new HashSet<String>();

    public static void processLeafRemoval(Block originalLogBlock, Player player, AutoTreeChop plugin, Config config, PlayerConfig playerConfig, boolean worldGuardEnabled, boolean residenceEnabled, boolean griefPreventionEnabled, boolean landsEnabled, LandsHook landsHook, ResidenceHook residenceHook, GriefPreventionHook griefPreventionHook, WorldGuardHook worldGuardHook) {
        if (!config.isLeafRemovalEnabled()) {
            return;
        }
        if (!player.hasPermission("autotreechop.leaves")) {
            return;
        }
        String playerKey = player.getUniqueId().toString();
        if (activeLeafRemovalSessions.contains(playerKey)) {
            return;
        }
        String sessionId = playerKey + "_" + System.currentTimeMillis();
        HashSet sessionRemovedLogs = new HashSet();
        removedLogsPerSession.put(sessionId, sessionRemovedLogs);
        activeLeafRemovalSessions.add(playerKey);
        Runnable leafRemovalTask = () -> {
            HashSet<Location> checkedLeafLocations = new HashSet<Location>();
            HashSet<Location> processingLeafLocations = new HashSet<Location>();
            long delayTicks = Math.max(config.getLeafRemovalDelayTicks(), 60L);
            LeafRemovalUtils.scheduleDelayedLeafRemoval(originalLogBlock, player, plugin, config, playerConfig, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook, checkedLeafLocations, processingLeafLocations, sessionId, playerKey, delayTicks);
        };
        if (AutoTreeChop.isFolia()) {
            plugin.getServer().getRegionScheduler().run((Plugin)plugin, originalLogBlock.getLocation(), task -> leafRemovalTask.run());
        } else {
            Bukkit.getScheduler().runTask((Plugin)plugin, leafRemovalTask);
        }
    }

    public static void trackRemovedLog(Location logLocation, String playerUUID) {
        String playerKey = playerUUID;
        for (Map.Entry<String, Set<Location>> entry : removedLogsPerSession.entrySet()) {
            if (!entry.getKey().startsWith(playerKey + "_")) continue;
            entry.getValue().add(logLocation.clone());
        }
    }

    private static void scheduleDelayedLeafRemoval(Block originalLogBlock, Player player, AutoTreeChop plugin, Config config, PlayerConfig playerConfig, boolean worldGuardEnabled, boolean residenceEnabled, boolean griefPreventionEnabled, boolean landsEnabled, LandsHook landsHook, ResidenceHook residenceHook, GriefPreventionHook griefPreventionHook, WorldGuardHook worldGuardHook, Set<Location> checkedLeafLocations, Set<Location> processingLeafLocations, String sessionId, String playerKey, long delayTicks) {
        Runnable delayedTask = () -> LeafRemovalUtils.startLeafRemoval(originalLogBlock, player, plugin, config, playerConfig, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook, checkedLeafLocations, processingLeafLocations, sessionId, playerKey);
        if (AutoTreeChop.isFolia()) {
            plugin.getServer().getRegionScheduler().runDelayed((Plugin)plugin, originalLogBlock.getLocation(), task -> delayedTask.run(), delayTicks);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, delayedTask, delayTicks);
        }
    }

    private static void startLeafRemoval(Block originalLogBlock, Player player, AutoTreeChop plugin, Config config, PlayerConfig playerConfig, boolean worldGuardEnabled, boolean residenceEnabled, boolean griefPreventionEnabled, boolean landsEnabled, LandsHook landsHook, ResidenceHook residenceHook, GriefPreventionHook griefPreventionHook, WorldGuardHook worldGuardHook, Set<Location> checkedLeafLocations, Set<Location> processingLeafLocations, String sessionId, String playerKey) {
        Set removedLogs = removedLogsPerSession.getOrDefault(sessionId, new HashSet());
        Collection<Block> leavesToRemove = LeafRemovalUtils.findLeavesToRemove(originalLogBlock, config.getLeafRemovalRadius(), checkedLeafLocations, config, removedLogs);
        if (leavesToRemove.isEmpty()) {
            LeafRemovalUtils.cleanupSession(sessionId, playerKey);
            return;
        }
        ArrayList<Block> leavesList = new ArrayList<Block>(leavesToRemove);
        int batchSize = config.getLeafRemovalBatchSize();
        LeafRemovalUtils.processLeavesBatch(leavesList, 0, batchSize, player, plugin, config, playerConfig, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook, processingLeafLocations, sessionId, playerKey);
    }

    private static void processLeavesBatch(List<Block> leavesList, int startIndex, int batchSize, Player player, AutoTreeChop plugin, Config config, PlayerConfig playerConfig, boolean worldGuardEnabled, boolean residenceEnabled, boolean griefPreventionEnabled, boolean landsEnabled, LandsHook landsHook, ResidenceHook residenceHook, GriefPreventionHook griefPreventionHook, WorldGuardHook worldGuardHook, Set<Location> processingLeafLocations, String sessionId, String playerKey) {
        int endIndex = Math.min(startIndex + batchSize, leavesList.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Block leafBlock = leavesList.get(i);
            if (config.getLeafRemovalCountsTowardsLimit() && !PermissionUtils.hasVipBlock(player, playerConfig, config) && playerConfig.getDailyBlocksBroken() >= config.getMaxBlocksPerDay()) break;
            LeafRemovalUtils.removeLeafBlock(leafBlock, player, config, playerConfig, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook, processingLeafLocations);
        }
        if (endIndex < leavesList.size()) {
            Runnable nextBatchTask = () -> LeafRemovalUtils.processLeavesBatch(leavesList, endIndex, batchSize, player, plugin, config, playerConfig, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook, processingLeafLocations, sessionId, playerKey);
            if (AutoTreeChop.isFolia()) {
                plugin.getServer().getRegionScheduler().runDelayed((Plugin)plugin, leavesList.get(endIndex).getLocation(), task -> nextBatchTask.run(), 1L);
            } else {
                Bukkit.getScheduler().runTaskLater((Plugin)plugin, nextBatchTask, 1L);
            }
        } else {
            LeafRemovalUtils.cleanupSession(sessionId, playerKey);
        }
    }

    private static void cleanupSession(String sessionId, String playerKey) {
        removedLogsPerSession.remove(sessionId);
        activeLeafRemovalSessions.remove(playerKey);
    }

    private static boolean removeLeafBlock(Block leafBlock, Player player, Config config, PlayerConfig playerConfig, boolean worldGuardEnabled, boolean residenceEnabled, boolean griefPreventionEnabled, boolean landsEnabled, LandsHook landsHook, ResidenceHook residenceHook, GriefPreventionHook griefPreventionHook, WorldGuardHook worldGuardHook, Set<Location> processingLeafLocations) {
        Location leafLocation = leafBlock.getLocation();
        if (processingLeafLocations.contains(leafLocation)) {
            return false;
        }
        if (!(TreeChopUtils.resCheck(player, leafLocation, residenceEnabled, residenceHook) && TreeChopUtils.landsCheck(player, leafLocation, landsEnabled, landsHook) && TreeChopUtils.gfCheck(player, leafLocation, griefPreventionEnabled, griefPreventionHook) && TreeChopUtils.wgCheck(player, leafLocation, worldGuardEnabled, worldGuardHook))) {
            return false;
        }
        processingLeafLocations.add(leafLocation);
        BlockBreakEvent breakEvent = new BlockBreakEvent(leafBlock, player);
        Bukkit.getPluginManager().callEvent((Event)breakEvent);
        if (!breakEvent.isCancelled()) {
            if (config.getLeafRemovalVisualEffects()) {
                EffectUtils.showLeafRemovalEffect(player, leafBlock);
            }
            if (config.getLeafRemovalDropItems()) {
                leafBlock.breakNaturally();
            } else {
                leafBlock.setType(Material.AIR);
            }
            if (config.getLeafRemovalCountsTowardsLimit()) {
                playerConfig.incrementDailyBlocksBroken();
            }
            processingLeafLocations.remove(leafLocation);
            return true;
        }
        processingLeafLocations.remove(leafLocation);
        return false;
    }

    private static Collection<Block> findLeavesToRemove(Block centerBlock, int radius, Set<Location> checkedLocations, Config config, Set<Location> removedLogs) {
        HashSet<Block> leavesToRemove = new HashSet<Block>();
        Location center = centerBlock.getLocation();
        String mode = config.getLeafRemovalMode().toLowerCase();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block checkBlock;
                    Location checkLoc = center.clone().add((double)x, (double)y, (double)z);
                    if (checkLoc.distanceSquared(center) > (double)(radius * radius) || !LeafRemovalUtils.isLeafBlock((checkBlock = checkLoc.getBlock()).getType(), config) || checkedLocations.contains(checkLoc)) continue;
                    boolean shouldRemove = false;
                    switch (mode) {
                        case "aggressive": {
                            shouldRemove = true;
                            break;
                        }
                        case "radius": {
                            shouldRemove = !LeafRemovalUtils.hasNearbyActiveLog(checkLoc, config, removedLogs, 4);
                            break;
                        }
                        default: {
                            shouldRemove = LeafRemovalUtils.isOrphanedLeaf(checkBlock, config, removedLogs);
                        }
                    }
                    if (shouldRemove) {
                        leavesToRemove.add(checkBlock);
                    }
                    checkedLocations.add(checkLoc);
                }
            }
        }
        return leavesToRemove;
    }

    private static boolean isOrphanedLeaf(Block leafBlock, Config config, Set<Location> removedLogs) {
        Location leafLoc = leafBlock.getLocation();
        if (!LeafRemovalUtils.hasNearbyActiveLog(leafLoc, config, removedLogs, 6)) {
            return true;
        }
        HashSet<Location> visited = new HashSet<Location>();
        return !LeafRemovalUtils.isConnectedToActiveLog(leafBlock, config, removedLogs, visited, 0);
    }

    private static boolean hasNearbyActiveLog(Location leafLoc, Config config, Set<Location> removedLogs, int checkRadius) {
        for (int x = -checkRadius; x <= checkRadius; ++x) {
            for (int y = -checkRadius; y <= checkRadius; ++y) {
                for (int z = -checkRadius; z <= checkRadius; ++z) {
                    Location checkLoc;
                    Block checkBlock;
                    if (x == 0 && y == 0 && z == 0 || !TreeChopUtils.isLog((checkBlock = (checkLoc = leafLoc.clone().add((double)x, (double)y, (double)z)).getBlock()).getType(), config) || LeafRemovalUtils.isLocationInSet(checkLoc, removedLogs)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isLocationInSet(Location loc, Set<Location> locationSet) {
        for (Location setLoc : locationSet) {
            if (setLoc.getBlockX() != loc.getBlockX() || setLoc.getBlockY() != loc.getBlockY() || setLoc.getBlockZ() != loc.getBlockZ() || !setLoc.getWorld().equals(loc.getWorld())) continue;
            return true;
        }
        return false;
    }

    private static boolean isConnectedToActiveLog(Block startBlock, Config config, Set<Location> removedLogs, Set<Location> visited, int depth) {
        if (depth > 8 || visited.size() > 100) {
            return false;
        }
        Location startLoc = startBlock.getLocation();
        if (visited.contains(startLoc)) {
            return false;
        }
        visited.add(startLoc);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    Location checkLoc = startLoc.clone().add((double)x, (double)y, (double)z);
                    Block checkBlock = checkLoc.getBlock();
                    Material checkType = checkBlock.getType();
                    if (TreeChopUtils.isLog(checkType, config) && !LeafRemovalUtils.isLocationInSet(checkLoc, removedLogs)) {
                        return true;
                    }
                    if (!LeafRemovalUtils.isLeafBlock(checkType, config) || visited.contains(checkLoc) || !LeafRemovalUtils.isConnectedToActiveLog(checkBlock, config, removedLogs, visited, depth + 1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isLeafBlock(Material material, Config config) {
        return config.getLeafTypes().contains(material);
    }
}

