/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.utils;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.milkteamc.autotreechop.AutoTreeChop;
import org.milkteamc.autotreechop.Config;
import org.milkteamc.autotreechop.hooks.GriefPreventionHook;
import org.milkteamc.autotreechop.hooks.LandsHook;
import org.milkteamc.autotreechop.hooks.ResidenceHook;
import org.milkteamc.autotreechop.hooks.WorldGuardHook;
import org.milkteamc.autotreechop.utils.EffectUtils;
import org.milkteamc.autotreechop.utils.TreeChopUtils;

public class TreeReplantUtils {
    public static void scheduleReplant(Player player, Block brokenLogBlock, Material originalLogType, AutoTreeChop plugin, Config config, boolean worldGuardEnabled, boolean residenceEnabled, boolean griefPreventionEnabled, boolean landsEnabled, LandsHook landsHook, ResidenceHook residenceHook, GriefPreventionHook griefPreventionHook, WorldGuardHook worldGuardHook) {
        if (!config.isAutoReplantEnabled()) {
            return;
        }
        Material saplingType = config.getSaplingForLog(originalLogType);
        if (saplingType == null) {
            return;
        }
        Location originalLocation = brokenLogBlock.getLocation().clone();
        Block below = brokenLogBlock.getRelative(BlockFace.DOWN);
        Runnable replantTask = () -> {
            Location plantLocation = TreeReplantUtils.findSuitablePlantLocation(originalLocation, config, plugin);
            if (plantLocation == null) {
                return;
            }
            if (!TreeReplantUtils.hasReplantPermission(player, plantLocation, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook)) {
                return;
            }
            boolean planted = TreeReplantUtils.plantSapling(player, plantLocation, saplingType, config, plugin);
            if (planted && config.getReplantVisualEffect()) {
                EffectUtils.showReplantEffect(player, plantLocation.getBlock());
            }
        };
        long delayTicks = config.getReplantDelayTicks();
        if (AutoTreeChop.isFolia()) {
            plugin.getServer().getRegionScheduler().runDelayed((Plugin)plugin, originalLocation, task -> replantTask.run(), delayTicks);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, replantTask, delayTicks);
        }
    }

    private static Location findSuitablePlantLocation(Location originalLocation, Config config, AutoTreeChop plugin) {
        int z;
        int x;
        Block originalBlock = originalLocation.getBlock();
        Block belowOriginal = originalBlock.getRelative(BlockFace.DOWN);
        if (TreeReplantUtils.isValidSoil(belowOriginal.getType(), config) && TreeReplantUtils.isClearForSapling(originalBlock)) {
            return originalLocation;
        }
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                Block checkBlock;
                Block belowCheck;
                if (x == 0 && z == 0 || !TreeReplantUtils.isValidSoil((belowCheck = (checkBlock = originalBlock.getRelative(x, 0, z)).getRelative(BlockFace.DOWN)).getType(), config) || !TreeReplantUtils.isClearForSapling(checkBlock)) continue;
                return checkBlock.getLocation();
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                if (x == 0 && z == 0) continue;
                for (int yOffset = 0; yOffset >= -3; --yOffset) {
                    Block checkBlock = originalBlock.getRelative(x, yOffset, z);
                    Block belowCheck = checkBlock.getRelative(BlockFace.DOWN);
                    if (!belowCheck.getType().isSolid() || !TreeReplantUtils.isValidSoil(belowCheck.getType(), config) || !TreeReplantUtils.isClearForSapling(checkBlock)) continue;
                    return checkBlock.getLocation();
                }
            }
        }
        for (int yOffset = 0; yOffset >= -10; --yOffset) {
            Block checkBlock = originalBlock.getRelative(0, yOffset, 0);
            Block belowCheck = checkBlock.getRelative(BlockFace.DOWN);
            if (!belowCheck.getType().isSolid() || !TreeReplantUtils.isValidSoil(belowCheck.getType(), config) || checkBlock.getType() != Material.AIR && !TreeReplantUtils.isClearForSapling(checkBlock)) continue;
            return checkBlock.getLocation();
        }
        return null;
    }

    private static boolean isValidSoil(Material material, Config config) {
        if (config.getValidSoilTypes().contains(material)) {
            return true;
        }
        switch (material) {
            case DIRT: 
            case GRASS_BLOCK: 
            case PODZOL: 
            case COARSE_DIRT: 
            case ROOTED_DIRT: 
            case MYCELIUM: 
            case FARMLAND: 
            case MOSS_BLOCK: 
            case MUD: 
            case MUDDY_MANGROVE_ROOTS: {
                return true;
            }
        }
        return false;
    }

    private static boolean isClearForSapling(Block block) {
        Material type = block.getType();
        if (type == Material.AIR) {
            return true;
        }
        if (type.toString().endsWith("_LOG")) {
            return true;
        }
        switch (type) {
            case SHORT_GRASS: 
            case TALL_GRASS: 
            case FERN: 
            case LARGE_FERN: 
            case DEAD_BUSH: 
            case DANDELION: 
            case POPPY: 
            case BLUE_ORCHID: 
            case ALLIUM: 
            case AZURE_BLUET: 
            case RED_TULIP: 
            case ORANGE_TULIP: 
            case WHITE_TULIP: 
            case PINK_TULIP: 
            case OXEYE_DAISY: 
            case CORNFLOWER: 
            case LILY_OF_THE_VALLEY: 
            case WITHER_ROSE: 
            case SUNFLOWER: 
            case LILAC: 
            case ROSE_BUSH: 
            case PEONY: 
            case WHEAT: 
            case CARROTS: 
            case POTATOES: 
            case BEETROOTS: 
            case SWEET_BERRY_BUSH: 
            case BROWN_MUSHROOM: 
            case RED_MUSHROOM: 
            case SUGAR_CANE: 
            case VINE: 
            case SNOW: {
                return true;
            }
        }
        String name = type.toString();
        return name.endsWith("_GRASS") || name.contains("FLOWER") || name.contains("SAPLING") || name.contains("LEAVES");
    }

    private static boolean plantSapling(Player player, Location location, Material saplingType, Config config, AutoTreeChop plugin) {
        Block block = location.getBlock();
        Block below = block.getRelative(BlockFace.DOWN);
        if (!TreeReplantUtils.isClearForSapling(block)) {
            return false;
        }
        if (!TreeReplantUtils.isValidSoil(below.getType(), config)) {
            return false;
        }
        if (config.getRequireSaplingInInventory() && !TreeReplantUtils.consumeSaplingFromInventory(player, saplingType)) {
            return false;
        }
        try {
            block.setType(saplingType);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean consumeSaplingFromInventory(Player player, Material saplingType) {
        ItemStack saplingStack;
        PlayerInventory inventory = player.getInventory();
        if (inventory.containsAtLeast(saplingStack = new ItemStack(saplingType, 1), 1)) {
            inventory.removeItem(new ItemStack[]{saplingStack});
            return true;
        }
        return false;
    }

    private static boolean hasReplantPermission(Player player, Location location, boolean worldGuardEnabled, boolean residenceEnabled, boolean griefPreventionEnabled, boolean landsEnabled, LandsHook landsHook, ResidenceHook residenceHook, GriefPreventionHook griefPreventionHook, WorldGuardHook worldGuardHook) {
        return TreeChopUtils.resCheck(player, location, residenceEnabled, residenceHook) && TreeChopUtils.landsCheck(player, location, landsEnabled, landsHook) && TreeChopUtils.gfCheck(player, location, griefPreventionEnabled, griefPreventionHook) && TreeChopUtils.wgCheck(player, location, worldGuardEnabled, worldGuardHook);
    }

    public static boolean isReplantEnabledForPlayer(Player player, Config config) {
        return config.isAutoReplantEnabled() && player.hasPermission("autotreechop.replant");
    }
}

