/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Stream;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModrinthUpdateChecker
implements Listener {
    private static final String API_URL = "https://api.modrinth.com/v2/project/{id}/version";
    private final JavaPlugin plugin;
    private final String projectId;
    private final String currentVersion;
    private final String loader;
    @Nullable
    private String minecraftVersion;
    @Nullable
    private String latestVersion;
    @Nullable
    private String downloadLink;
    @Nullable
    private String changelogLink;
    @Nullable
    private String donationLink;
    @Nullable
    private String supportLink;
    private boolean notifyOps = false;
    private String notifyPermission = null;
    private int checkIntervalHours = 24;
    private long lastCheckTime = 0L;
    private UpdateCheckResult lastResult = UpdateCheckResult.UNKNOWN;
    private boolean suppressUpToDateMessage = false;
    private boolean coloredConsole = true;

    public ModrinthUpdateChecker(@NotNull JavaPlugin plugin, @NotNull String projectId, @NotNull String loader) {
        this.plugin = plugin;
        this.projectId = projectId;
        this.currentVersion = plugin.getDescription().getVersion();
        this.loader = loader;
        this.minecraftVersion = plugin.getServer().getBukkitVersion().split("-")[0];
    }

    public ModrinthUpdateChecker setMinecraftVersion(@Nullable String version) {
        this.minecraftVersion = version;
        return this;
    }

    public ModrinthUpdateChecker setDownloadLink(@NotNull String link) {
        this.downloadLink = link;
        return this;
    }

    public ModrinthUpdateChecker setChangelogLink(@NotNull String link) {
        this.changelogLink = link;
        return this;
    }

    public ModrinthUpdateChecker setDonationLink(@NotNull String link) {
        this.donationLink = link;
        return this;
    }

    public ModrinthUpdateChecker setSupportLink(@NotNull String link) {
        this.supportLink = link;
        return this;
    }

    public ModrinthUpdateChecker setNotifyOpsOnJoin(boolean notify) {
        this.notifyOps = notify;
        return this;
    }

    public ModrinthUpdateChecker setNotifyByPermissionOnJoin(@NotNull String permission) {
        this.notifyPermission = permission;
        return this;
    }

    public ModrinthUpdateChecker checkEveryXHours(int hours) {
        this.checkIntervalHours = hours;
        return this;
    }

    public ModrinthUpdateChecker setSuppressUpToDateMessage(boolean suppress) {
        this.suppressUpToDateMessage = suppress;
        return this;
    }

    public ModrinthUpdateChecker setColoredConsoleOutput(boolean colored) {
        this.coloredConsole = colored;
        return this;
    }

    public ModrinthUpdateChecker checkNow() {
        if (this.notifyOps || this.notifyPermission != null) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
        this.performCheck();
        return this;
    }

    public ModrinthUpdateChecker startPeriodicCheck() {
        this.checkNow();
        long intervalTicks = (long)(this.checkIntervalHours * 60 * 60) * 20L;
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::performCheck, intervalTicks, intervalTicks);
        return this;
    }

    private void performCheck() {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(API_URL.replace("{id}", this.projectId))).header("User-Agent", "minecraft-plugin/" + this.plugin.getName() + "/" + this.currentVersion).GET().build();
            ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAcceptAsync(response -> {
                if (response.statusCode() != 200) {
                    this.lastResult = UpdateCheckResult.UNKNOWN;
                    this.plugin.getLogger().warning("Failed to check for updates (HTTP " + response.statusCode() + ")");
                    return;
                }
                try {
                    JsonArray versionsArray = JsonParser.parseString((String)((String)response.body())).getAsJsonArray();
                    String latest = this.getLatestVersion(versionsArray);
                    if (latest == null) {
                        this.lastResult = UpdateCheckResult.UNKNOWN;
                        return;
                    }
                    this.latestVersion = latest;
                    this.lastCheckTime = System.currentTimeMillis();
                    String currentRaw = ModrinthUpdateChecker.getRawVersion(this.currentVersion);
                    String latestRaw = ModrinthUpdateChecker.getRawVersion(latest);
                    this.lastResult = ModrinthUpdateChecker.compareVersions(latestRaw, currentRaw) > 0 ? UpdateCheckResult.NEW_VERSION_AVAILABLE : UpdateCheckResult.RUNNING_LATEST_VERSION;
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, this::printCheckResultToConsole);
                }
                catch (Exception e) {
                    this.lastResult = UpdateCheckResult.UNKNOWN;
                    this.plugin.getLogger().log(Level.WARNING, "Error parsing update check response", e);
                }
            })).exceptionally(throwable -> {
                this.lastResult = UpdateCheckResult.UNKNOWN;
                return null;
            });
        }
        catch (Exception e) {
            this.lastResult = UpdateCheckResult.UNKNOWN;
        }
    }

    @Nullable
    private String getLatestVersion(JsonArray versions) {
        return versions.asList().stream().map(JsonElement::getAsJsonObject).filter(version -> "release".equalsIgnoreCase(version.get("version_type").getAsString())).filter(this::isVersionCompatible).map(version -> version.get("version_number").getAsString()).map(ModrinthUpdateChecker::getRawVersion).max(ModrinthUpdateChecker::compareVersions).orElse(null);
    }

    private boolean isVersionCompatible(JsonObject version) {
        JsonArray versions = version.get("game_versions").getAsJsonArray();
        JsonArray loaders = version.get("loaders").getAsJsonArray();
        return (this.minecraftVersion == null || versions.contains((JsonElement)new JsonPrimitive(this.minecraftVersion))) && loaders.contains((JsonElement)new JsonPrimitive(this.loader));
    }

    private static String getRawVersion(String version) {
        if (version.isEmpty()) {
            return version;
        }
        version = version.replaceAll("^\\D+", "");
        String[] split = version.split("\\+");
        return split[0];
    }

    private static int compareVersions(String v1, String v2) {
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int p2;
            int p1 = i < parts1.length ? ModrinthUpdateChecker.parseVersionPart(parts1[i]) : 0;
            int n = p2 = i < parts2.length ? ModrinthUpdateChecker.parseVersionPart(parts2[i]) : 0;
            if (p1 == p2) continue;
            return Integer.compare(p1, p2);
        }
        if (v1.matches(".*(?i)(snapshot|beta|dev|rc).*") && !v2.matches(".*(?i)(snapshot|beta|dev|rc).*")) {
            return -1;
        }
        if (!v1.matches(".*(?i)(snapshot|beta|dev|rc).*") && v2.matches(".*(?i)(snapshot|beta|dev|rc).*")) {
            return 1;
        }
        return 0;
    }

    private static int parseVersionPart(String part) {
        try {
            return Integer.parseInt(part.replaceAll("[^0-9]", ""));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.lastResult != UpdateCheckResult.NEW_VERSION_AVAILABLE) {
            return;
        }
        boolean shouldNotify = false;
        if (this.notifyOps && player.isOp()) {
            shouldNotify = true;
        }
        if (this.notifyPermission != null && player.hasPermission(this.notifyPermission)) {
            shouldNotify = true;
        }
        if (shouldNotify) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.printCheckResultToPlayer(player, false), 40L);
        }
    }

    private void printCheckResultToConsole() {
        if (this.lastResult == UpdateCheckResult.UNKNOWN) {
            this.plugin.getLogger().warning("Could not check for updates.");
            return;
        }
        if (this.lastResult == UpdateCheckResult.RUNNING_LATEST_VERSION) {
            if (this.suppressUpToDateMessage) {
                return;
            }
            this.plugin.getLogger().info(String.format("You are using the latest version of %s.", this.plugin.getName()));
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.format("There is a new version of %s available!", this.plugin.getName()));
        lines.add(" ");
        lines.add(String.format("Your version:   %s%s", this.coloredConsole ? ChatColor.RED : "", this.currentVersion));
        lines.add(String.format("Latest version: %s%s", this.coloredConsole ? ChatColor.GREEN : "", this.latestVersion));
        if (this.downloadLink != null) {
            lines.add(" ");
            lines.add("Please update to the newest version.");
            lines.add(" ");
            lines.add("Download:");
            lines.add("  " + this.downloadLink);
        }
        if (this.supportLink != null) {
            lines.add(" ");
            lines.add("Support:");
            lines.add("  " + this.supportLink);
        }
        if (this.donationLink != null) {
            lines.add(" ");
            lines.add("Donate:");
            lines.add("  " + this.donationLink);
        }
        this.printNiceBoxToConsole(lines);
    }

    private void printCheckResultToPlayer(Player player, boolean showMessageWhenLatestVersion) {
        if (this.lastResult == UpdateCheckResult.NEW_VERSION_AVAILABLE) {
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "There is a new version of " + String.valueOf(ChatColor.GOLD) + this.plugin.getName() + String.valueOf(ChatColor.GRAY) + " available.");
            this.sendLinks(player);
            player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "Latest version: " + String.valueOf(ChatColor.GREEN) + this.latestVersion + String.valueOf(ChatColor.DARK_GRAY) + " | Your version: " + String.valueOf(ChatColor.RED) + this.currentVersion);
            player.sendMessage("");
        } else if (this.lastResult == UpdateCheckResult.UNKNOWN) {
            player.sendMessage(String.valueOf(ChatColor.GOLD) + this.plugin.getName() + String.valueOf(ChatColor.RED) + " could not check for updates.");
        } else if (showMessageWhenLatestVersion) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You are running the latest version of " + String.valueOf(ChatColor.GOLD) + this.plugin.getName());
        }
    }

    private void printNiceBoxToConsole(List<String> lines) {
        int longestLine = 0;
        for (String line : lines) {
            longestLine = Math.max(line.length(), longestLine);
        }
        longestLine = Math.min(longestLine + 4, 120);
        StringBuilder dash = new StringBuilder();
        Stream.generate(() -> "*").limit(longestLine).forEach(dash::append);
        this.plugin.getLogger().log(Level.WARNING, dash.toString());
        for (String line : lines) {
            this.plugin.getLogger().log(Level.WARNING, "* " + line);
        }
        this.plugin.getLogger().log(Level.WARNING, dash.toString());
    }

    private void sendLinks(@NotNull Player player) {
        ArrayList<TextComponent> links = new ArrayList<TextComponent>();
        if (this.downloadLink != null) {
            links.add(ModrinthUpdateChecker.createLink("Download", this.downloadLink));
        }
        if (this.donationLink != null) {
            links.add(ModrinthUpdateChecker.createLink("Donate", this.donationLink));
        }
        if (this.changelogLink != null) {
            links.add(ModrinthUpdateChecker.createLink("Changelog", this.changelogLink));
        }
        if (this.supportLink != null) {
            links.add(ModrinthUpdateChecker.createLink("Support", this.supportLink));
        }
        if (links.isEmpty()) {
            return;
        }
        TextComponent placeholder = new TextComponent(" | ");
        placeholder.setColor(net.md_5.bungee.api.ChatColor.GRAY);
        TextComponent text = new TextComponent("");
        Iterator iterator = links.iterator();
        while (iterator.hasNext()) {
            text.addExtra((BaseComponent)iterator.next());
            if (!iterator.hasNext()) continue;
            text.addExtra((BaseComponent)placeholder);
        }
        player.spigot().sendMessage((BaseComponent)text);
    }

    @NotNull
    private static TextComponent createLink(@NotNull String text, @NotNull String link) {
        ComponentBuilder lore = new ComponentBuilder("Link: ").bold(true).append(link).bold(false);
        TextComponent component = new TextComponent(text);
        component.setBold(Boolean.valueOf(true));
        component.setColor(net.md_5.bungee.api.ChatColor.GOLD);
        component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, link));
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, lore.create()));
        return component;
    }

    public UpdateCheckResult getLastResult() {
        return this.lastResult;
    }

    @Nullable
    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public static enum UpdateCheckResult {
        RUNNING_LATEST_VERSION,
        NEW_VERSION_AVAILABLE,
        UNKNOWN;

    }
}

