/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.tinytranslations.util.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Stack;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleStringParser<TokenT, TokenValueT, NodeT> {
    private final Queue<Region> regions = new LinkedList<Region>();
    private final Stack<Marker> openMarkers = new Stack();
    private final LinkedList<TokenValueT> tokens;
    private int currentToken = 0;

    public SimpleStringParser(List<TokenValueT> tokens) {
        this.tokens = new LinkedList<TokenValueT>(tokens);
    }

    public abstract Node parse();

    @Nullable
    public abstract TokenT getTokenType(@Nullable TokenValueT var1);

    public Marker mark() {
        Marker m = new Marker();
        m.start = this.currentToken;
        this.openMarkers.push(m);
        return m;
    }

    public void advance() {
        ++this.currentToken;
    }

    public TokenValueT getCurrentToken() {
        if (this.tokens.size() <= this.currentToken) {
            return null;
        }
        return this.tokens.get(this.currentToken);
    }

    public TokenT lookAhead(int count) {
        if (this.currentToken + count >= this.tokens.size()) {
            return null;
        }
        return this.getTokenType(this.tokens.get(this.currentToken + count));
    }

    public String getTokenText() {
        return this.getCurrentToken().toString();
    }

    public TokenT getTokenType() {
        return this.getTokenType(this.getCurrentToken());
    }

    public Node buildTree() {
        ArrayList<Node> sib = new ArrayList<Node>();
        while (!this.regions.isEmpty()) {
            Region region = this.regions.poll();
            ArrayList<Node> children = new ArrayList<Node>();
            for (Node n : new ArrayList(sib)) {
                if (n.start < region.start || n.end > region.end) continue;
                sib.remove(n);
                children.add(n);
            }
            Node n = new Node(region.type, region.start, region.end, children);
            sib.add(n);
        }
        return new Node(null, 0, this.tokens.size(), new ArrayList<Node>(sib));
    }

    public class Marker {
        int start = 0;
        boolean incomplete = true;

        public void rollback() {
            while (!SimpleStringParser.this.openMarkers.peek().equals(this)) {
                SimpleStringParser.this.openMarkers.pop().incomplete = false;
            }
            SimpleStringParser.this.regions.removeIf(region -> region.start >= this.start);
            SimpleStringParser.this.openMarkers.pop();
            SimpleStringParser.this.currentToken = this.start;
            this.incomplete = false;
        }

        public void dispose() {
            this.incomplete = false;
            SimpleStringParser.this.openMarkers.pop();
        }

        public void done(NodeT type) {
            if (!this.incomplete) {
                throw new IllegalStateException("This marker is not valid");
            }
            if (SimpleStringParser.this.openMarkers.isEmpty() || !SimpleStringParser.this.openMarkers.peek().equals(this)) {
                throw new IllegalStateException("Complete or dispose all markers first that were added after this marker.");
            }
            SimpleStringParser.this.regions.add(new Region(this.start, SimpleStringParser.this.currentToken, type));
            this.incomplete = false;
            SimpleStringParser.this.openMarkers.pop();
        }

        public String toString() {
            return SimpleStringParser.this.tokens.subList(this.start, SimpleStringParser.this.currentToken).stream().map(Objects::toString).collect(Collectors.joining("")) + (this.incomplete ? "..." : "");
        }
    }

    private class Region {
        final int start;
        final int end;
        final NodeT type;
        final TokenValueT[] tokens;

        private Region(int start, int end, NodeT type) {
            this.start = start;
            this.end = end;
            this.type = type;
            this.tokens = SimpleStringParser.this.tokens.subList(start, end).toArray();
        }

        public String toString() {
            return "<" + this.type + ">['" + Arrays.stream(this.tokens).map(Objects::toString).collect(Collectors.joining("")) + "']";
        }
    }

    public final class Node {
        private final NodeT type;
        private final List<Node> children;
        int start;
        int end;
        private Node parent;
        private String hardCode = null;

        public Node(NodeT type, int start, int end, String hardCode) {
            this(type, start, end, new ArrayList<Node>());
            this.hardCode = hardCode;
        }

        public Node(NodeT type, int start, int end, List<Node> children) {
            this.type = type;
            this.start = start;
            this.end = end;
            this.children = children;
            for (Node child : this.children) {
                child.parent = this;
            }
        }

        private Node(Region region) {
            this(region.type, region.start, region.end, new ArrayList<Node>());
        }

        public void replace(String other) {
            this.replace(new Node(null, this.start, this.end, other));
        }

        public void replace(Node other) {
            if (this.parent == null) {
                return;
            }
            try {
                int index = this.parent.children.indexOf(this);
                this.parent.children.set(index, other);
            }
            catch (Throwable t) {
                this.parent = null;
            }
        }

        public void tree(StringBuilder builder, int indent) {
            builder.append(" ".repeat(indent)).append(Objects.toString(this.type, "null")).append("\n");
            for (Node child : this.children) {
                child.tree(builder, indent + 1);
            }
        }

        public String getText() {
            if (this.hardCode != null) {
                return this.hardCode;
            }
            if (this.start == this.end) {
                return "";
            }
            StringBuilder s = new StringBuilder();
            int i = this.start;
            while (i < this.end) {
                int before = i;
                for (Node child : this.children) {
                    if (child.start != i) continue;
                    s.append(child.getText());
                    i = Integer.max(i, child.end);
                }
                if (before != i) continue;
                s.append(SimpleStringParser.this.tokens.get(i++));
            }
            return s.toString();
        }

        public String toString() {
            return this.getText();
        }

        public NodeT getType() {
            return this.type;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public Node getParent() {
            return this.parent;
        }

        public String getHardCode() {
            return this.hardCode;
        }
    }
}

