/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.tinytranslations;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.milkteamc.autotreechop.libs.tinytranslations.GlobalMessages;
import org.milkteamc.autotreechop.libs.tinytranslations.Message;
import org.milkteamc.autotreechop.libs.tinytranslations.MessageTranslator;
import org.milkteamc.autotreechop.libs.tinytranslations.MessageTranslatorImpl;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.Component;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import org.milkteamc.autotreechop.libs.tinytranslations.nanomessage.NanoMessage;
import org.milkteamc.autotreechop.libs.tinytranslations.storage.properties.PropertiesMessageStorage;
import org.milkteamc.autotreechop.libs.tinytranslations.storage.properties.PropertiesStyleStorage;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.TinyObjectMapping;

public class TinyTranslations {
    private static final Logger LOGGER = Logger.getLogger("Translations");
    public static final Locale FALLBACK_DEFAULT_LOCALE = Locale.ENGLISH;
    public static final NanoMessage NM = NanoMessage.nanoMessage();

    protected TinyTranslations() {
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static MessageTranslator application(String name) {
        MessageTranslatorImpl tr = new MessageTranslatorImpl(null, name);
        TinyTranslations.applyDefaultObjectResolvers(tr);
        return tr;
    }

    public static Message[] messageFieldsFromClass(Class<?> messageClass) {
        TinyTranslations.getLogger().fine("Fetching Messages from class " + messageClass);
        try {
            TinyTranslations.class.getClassLoader().loadClass(messageClass.getName());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Field[] fields = (Field[])Arrays.stream(messageClass.getDeclaredFields()).filter(field -> Message.class.isAssignableFrom(field.getType())).toArray(Field[]::new);
        Message[] messages = new Message[fields.length];
        int i = 0;
        for (Field messageField : fields) {
            try {
                messages[i++] = (Message)messageField.get(messageClass);
            }
            catch (Throwable t) {
                TinyTranslations.getLogger().log(Level.WARNING, "Could not extract message '" + messageField.getName() + "' from class " + messageClass.getSimpleName(), t);
            }
        }
        TinyTranslations.getLogger().fine("Fetchind Messages from class " + messageClass);
        return messages;
    }

    public static MessageTranslator globalTranslator(final File root) {
        TinyTranslations.getLogger().fine("Creating globalTranslator " + root.getPath());
        TinyTranslations.initGlobalFiles(root);
        MessageTranslatorImpl global = new MessageTranslatorImpl(null, "global"){

            @Override
            public void loadStyles() {
                if (TinyTranslations.initGlobalFiles(root) || !new File(root, "/lang/global_styles.properties").exists()) {
                    TinyTranslations.writeResourceIfNotExists(root, "lang/global_styles.properties", "lang/global_styles.properties");
                } else {
                    TinyTranslations.writeMissingDefaultStyles(this);
                }
                super.loadStyles();
            }

            @Override
            public void loadLocales() {
                boolean init = TinyTranslations.initGlobalFiles(root);
                for (Locale locale : GlobalMessages.LOCALES) {
                    String s = "lang/global_messages_" + locale.toLanguageTag().replaceAll("-", "_") + ".properties";
                    if (!init && new File(root, s).exists()) continue;
                    TinyTranslations.writeResourceIfNotExists(root, s);
                }
                super.loadLocales();
            }

            @Override
            public void loadLocale(Locale locale) {
                String s = "lang/global_messages_" + locale.toLanguageTag().replaceAll("-", "_") + ".properties";
                if (TinyTranslations.initGlobalFiles(root) || !new File(root, s).exists()) {
                    TinyTranslations.writeResourceIfNotExists(root, s);
                }
                super.loadLocale(locale);
            }
        };
        global.setMessageStorage(new PropertiesMessageStorage(new File(root, "/lang/"), "global_messages_", ""));
        global.setStyleStorage(new PropertiesStyleStorage(new File(root, "lang/global_styles.properties")));
        global.addMessages(TinyTranslations.messageFieldsFromClass(GlobalMessages.class));
        global.loadStyles();
        global.loadLocales();
        TinyTranslations.applyDefaultObjectResolvers(global);
        return global;
    }

    private static boolean initGlobalFiles(File directory) {
        boolean init;
        TinyTranslations.getLogger().finer("Initializing global files in " + directory.getPath());
        if (!directory.exists()) {
            throw new IllegalArgumentException("Global translations directory must exist.");
        }
        File globalLangDir = new File(directory, "/lang/");
        boolean bl = init = !globalLangDir.exists();
        if (init && !globalLangDir.mkdirs()) {
            throw new IllegalStateException("Could not create /lang/ directory for global translations.");
        }
        if (init) {
            TinyTranslations.writeResourceIfNotExists(globalLangDir, "README.txt");
        }
        return init;
    }

    private static void writeResourceIfNotExists(File langDir, String name) {
        TinyTranslations.writeResourceIfNotExists(langDir, name, name);
    }

    private static void writeResourceIfNotExists(File langDir, String name, String as) {
        File file = new File(langDir, as);
        TinyTranslations.getLogger().finer("Creating resource in storage: " + file.getPath());
        if (file.exists()) {
            return;
        }
        try {
            if (!file.createNewFile()) {
                throw new IllegalStateException("Could not create resource");
            }
            InputStream is = TinyTranslations.class.getResourceAsStream("/" + name);
            if (is == null) {
                throw new IllegalArgumentException("Could not load resource with name '" + name + "'.");
            }
            FileOutputStream os = new FileOutputStream(file);
            os.write(is.readAllBytes());
            os.close();
            is.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not load resource with name '" + name + "'.", e);
        }
    }

    private static void writeMissingDefaultStyles(MessageTranslator translator) {
        File tempFile;
        TinyTranslations.getLogger().finer("Creating missing default styles");
        try {
            tempFile = File.createTempFile("stream_to_file", ".properties");
            tempFile.deleteOnExit();
            try (InputStream is = TinyTranslations.class.getResourceAsStream("/lang/global_styles.properties");
                 FileOutputStream out = new FileOutputStream(tempFile);){
                out.write(is.readAllBytes());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not create temp file to append missing default styles.");
        }
        PropertiesStyleStorage storage = new PropertiesStyleStorage(tempFile);
        storage.loadStyles().forEach((s, messageStyle) -> {
            if (!translator.getStyleSet().containsKey(s)) {
                translator.getStyleSet().put(s, messageStyle);
            }
        });
        if (translator.getStyleStorage() != null) {
            translator.getStyleStorage().writeStyles(translator.getStyleSet());
        }
        TinyTranslations.getLogger().finer("Created missing default styles");
    }

    private static void applyDefaultObjectResolvers(MessageTranslator translator) {
        TinyTranslations.getLogger().fine("Applying general Object Resolvers to " + translator.getPath());
        translator.add(TinyObjectMapping.alwaysConvert(String.class, Component::text));
        translator.add(TinyObjectMapping.builder(Number.class).withFallbackResolver((value, context, argumentQueue) -> Formatter.number("avoid_name_collisions", value).resolve("avoid_name_collisions", argumentQueue, context)).build());
        translator.add(TinyObjectMapping.builder(Boolean.class).withFallbackConversion(Component::text).build());
        translator.add(TinyObjectMapping.builder(Character.TYPE).withFallbackConversion(Component::text).build());
        translator.add(TinyObjectMapping.builder(Locale.class).withFallbackConversion(l -> Component.text(l.toLanguageTag())).build());
        translator.add(TinyObjectMapping.alwaysConvert(Supplier.class, Supplier::get));
        translator.add(TinyObjectMapping.alwaysConvert(CompletableFuture.class, CompletableFuture::join));
        translator.add(TinyObjectMapping.alwaysConvert(Optional.class, o -> o.orElse(null)));
    }
}

