/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.tinytranslations.tinyobject;

import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.FallbackContextConsumer;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.TinyObjectMappingImpl;

public interface TinyObjectMapping {
    public boolean matches(Object var1);

    public boolean containsKey(String var1);

    @Nullable
    public Object resolve(@Nullable Object var1);

    @Nullable
    public Object resolve(@Nullable Object var1, String var2);

    public static <T> TinyObjectMapping alwaysConvert(Class<T> match, Function<T, Object> conversion) {
        TinyObjectMappingImpl impl = new TinyObjectMappingImpl(match);
        impl.overrideAll = conversion;
        return impl;
    }

    public static <T> Builder<T> builder(Class<T> match) {
        return new Builder<T>(match);
    }

    public static class Builder<T> {
        private final TinyObjectMappingImpl impl;

        public Builder(Class<T> match) {
            this.impl = new TinyObjectMappingImpl(match);
        }

        public Builder<T> withFallbackResolver(FallbackContextConsumer<T> function) {
            this.impl.fallbackContextConsumer = function;
            return this;
        }

        public Builder<T> withFallbackConversion(Function<T, Object> production) {
            this.impl.fallbackContextConsumer = (value, context, argumentQueue) -> production.apply(value);
            return this;
        }

        public Builder<T> with(String value, Function<T, Object> production) {
            this.impl.productions.put(value, production);
            return this;
        }

        public TinyObjectMapping build() {
            return this.impl;
        }
    }
}

