/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer;

import com.cobblemon.mod.common.api.storage.party.PartyStore;
import java.util.List;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.player.PlayerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer.AbstractTrainerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.CooldownElapsedPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.ForbiddenAbilityPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.ForbiddenHeldItemPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.ForbiddenLabelPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.ForbiddenMovePredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.ForbiddenPokemonPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MaximumPartySizePredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MessagePredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MinimumPartySizePredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.RematchAllowedPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.RequiredAbilityPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.RequiredHeldItemPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.RequiredLabelPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.RequiredMovePredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.RequiredPokemonPredicate;
import kiwiapollo.cobblemontrainerbattle.common.LevelMode;
import kiwiapollo.cobblemontrainerbattle.exception.PokemonParseException;
import kiwiapollo.cobblemontrainerbattle.global.preset.TrainerPreset;
import kiwiapollo.cobblemontrainerbattle.pokemon.FlatLevelShowdownPokemonParser;
import kiwiapollo.cobblemontrainerbattle.pokemon.ShowdownPokemon;

public class FlatLevelTrainer
extends AbstractTrainerBattleParticipant {
    private final List<MessagePredicate<PlayerBattleParticipant>> predicates;

    public FlatLevelTrainer(String id, TrainerPreset preset, List<ShowdownPokemon> team) {
        super(id, preset, FlatLevelTrainer.toPartyStore(team));
        this.predicates = List.of(new RematchAllowedPredicate(id, preset.isRematchAllowed), new CooldownElapsedPredicate(id, preset.cooldownInSeconds), new MaximumPartySizePredicate.PlayerPredicate(preset.maximumPartySize), new MinimumPartySizePredicate.PlayerPredicate(preset.minimumPartySize), new RequiredLabelPredicate(preset.requiredLabel), new RequiredPokemonPredicate(preset.requiredPokemon), new RequiredHeldItemPredicate(preset.requiredHeldItem), new RequiredAbilityPredicate(preset.requiredAbility), new RequiredMovePredicate(preset.requiredMove), new ForbiddenLabelPredicate(preset.forbiddenLabel), new ForbiddenPokemonPredicate(preset.forbiddenPokemon), new ForbiddenHeldItemPredicate(preset.forbiddenHeldItem), new ForbiddenAbilityPredicate(preset.forbiddenAbility), new ForbiddenMovePredicate(preset.forbiddenMove));
    }

    private static PartyStore toPartyStore(List<ShowdownPokemon> team) {
        PartyStore party = new PartyStore(UUID.randomUUID());
        for (ShowdownPokemon showdownPokemon : team) {
            try {
                party.add(new FlatLevelShowdownPokemonParser().toCobblemonPokemon(showdownPokemon));
            }
            catch (PokemonParseException pokemonParseException) {}
        }
        return party;
    }

    @Override
    public List<MessagePredicate<PlayerBattleParticipant>> getPredicates() {
        return this.predicates;
    }

    @Override
    public LevelMode getLevelMode() {
        return LevelMode.FLAT;
    }
}

