/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer;

import com.cobblemon.mod.common.api.battles.model.actor.AIBattleActor;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.battle.battleactor.EntityBackedTrainerBattleActor;
import kiwiapollo.cobblemontrainerbattle.battle.battleactor.SafeCopyBattlePokemonFactory;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.Generation5AI;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.player.PlayerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer.TrainerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MessagePredicate;
import kiwiapollo.cobblemontrainerbattle.block.PokeBallBox;
import kiwiapollo.cobblemontrainerbattle.block.PokeBallBoxBlockEntity;
import kiwiapollo.cobblemontrainerbattle.common.LevelMode;
import kiwiapollo.cobblemontrainerbattle.entity.TrainerTexture;
import kiwiapollo.cobblemontrainerbattle.item.FilledPokeBall;
import kiwiapollo.cobblemontrainerbattle.villager.PokeBallEngineerVillager;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_4140;
import net.minecraft.class_4208;

public class PokeBallEngineerBackedTrainer
implements TrainerBattleParticipant {
    private final PartyStore party;
    private final UUID uuid;
    private final class_1646 villager;

    public PokeBallEngineerBackedTrainer(class_1646 villager) {
        this.villager = villager;
        this.party = PokeBallEngineerBackedTrainer.toPartyStore(PokeBallEngineerBackedTrainer.getPokemon(PokeBallEngineerBackedTrainer.getPokeBallBox(villager)));
        this.uuid = UUID.randomUUID();
        if (PokeBallEngineerBackedTrainer.isPartyEmpty(this.party)) {
            throw new IllegalStateException();
        }
        if (!PokeBallEngineerBackedTrainer.isPokeBallEngineer(this.villager)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public String getId() {
        return this.villager.method_5476().getString();
    }

    @Override
    public BattleAI getBattleAI() {
        return new Generation5AI();
    }

    @Override
    public void setBattleAI(BattleAI battleAI) {
    }

    @Override
    @Deprecated
    public String getBattleAIName() {
        return "generation5";
    }

    @Override
    public BattleFormat getBattleFormat() {
        return BattleFormat.Companion.getGEN_9_SINGLES();
    }

    @Override
    public Optional<class_3414> getBattleTheme() {
        return Optional.empty();
    }

    @Override
    public LevelMode getLevelMode() {
        return LevelMode.NORMAL;
    }

    @Override
    public List<BattlePokemon> getBattleTeam(class_3222 player) {
        List<BattlePokemon> team = this.getParty().toGappyList().stream().filter(Objects::nonNull).map(new SafeCopyBattlePokemonFactory()).toList();
        team.forEach(pokemon -> pokemon.getEffectedPokemon().heal());
        return team;
    }

    @Override
    public boolean isSpawningAllowed() {
        return false;
    }

    @Override
    public List<MessagePredicate<PlayerBattleParticipant>> getPredicates() {
        return List.of();
    }

    @Override
    public AIBattleActor createBattleActor(class_3222 player) {
        return new EntityBackedTrainerBattleActor(this.getName(), this.getUuid(), this.getBattleTeam(player), this.getBattleAI(), this.getEntity(player));
    }

    @Override
    public class_1309 getEntity(class_3222 player) {
        return this.villager;
    }

    @Override
    public void onPlayerDefeat(class_3222 player) {
    }

    @Override
    public void onPlayerVictory(class_3222 player) {
        this.emitRedstonePulse();
    }

    private void emitRedstonePulse() {
        try {
            int DURATION = 20;
            class_1937 world = this.villager.method_37908();
            class_2338 pos = this.villager.method_18868().method_46873(class_4140.field_18439).map(class_4208::comp_2208).get();
            class_2680 state = world.method_8320(pos);
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)PokeBallBox.POWERED, (Comparable)Boolean.valueOf(true)), 3);
            world.method_8492(pos, state.method_26204(), pos);
            world.method_39279(pos, state.method_26204(), 20);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public class_2960 getTexture() {
        return TrainerTexture.RED.getIdentifier();
    }

    @Override
    public String getName() {
        return this.villager.method_5476().getString();
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public PartyStore getParty() {
        return this.party;
    }

    private static boolean isPartyEmpty(PartyStore party) {
        return party.occupied() == 0;
    }

    private static boolean isPokeBallEngineer(class_1646 villager) {
        try {
            return villager.method_7231().method_16924().equals((Object)PokeBallEngineerVillager.PROFESSION);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private static PokeBallBoxBlockEntity getPokeBallBox(class_1646 villager) {
        class_2338 pos = villager.method_18868().method_46873(class_4140.field_18439).map(class_4208::comp_2208).get();
        class_2586 block = villager.method_37908().method_8321(pos);
        return (PokeBallBoxBlockEntity)block;
    }

    private static PartyStore toPartyStore(List<Pokemon> pokemon) {
        PartyStore party = new PartyStore(UUID.randomUUID());
        ArrayList<Pokemon> random = new ArrayList<Pokemon>(pokemon);
        Collections.shuffle(random);
        PokeBallEngineerBackedTrainer.getFirstSix(random).forEach(arg_0 -> ((PartyStore)party).add(arg_0));
        return party;
    }

    private static List<Pokemon> getPokemon(PokeBallBoxBlockEntity block) {
        ArrayList<Pokemon> pokemon = new ArrayList<Pokemon>();
        for (class_1799 stack : PokeBallEngineerBackedTrainer.getFilledPokeBalls(block)) {
            try {
                pokemon.add(FilledPokeBall.getPokemon(block.method_10997().method_30349(), stack));
            }
            catch (IllegalStateException | NullPointerException runtimeException) {}
        }
        return pokemon;
    }

    private static List<class_1799> getFilledPokeBalls(PokeBallBoxBlockEntity block) {
        return PokeBallEngineerBackedTrainer.getItemStacks(block).stream().filter(stack -> stack.method_7909() instanceof FilledPokeBall).toList();
    }

    private static List<class_1799> getItemStacks(PokeBallBoxBlockEntity block) {
        ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
        for (int i = 0; i < block.method_5439(); ++i) {
            itemStacks.add(block.method_5438(i));
        }
        return itemStacks;
    }

    private static List<Pokemon> getFirstSix(List<Pokemon> pokemon) {
        int MAXIMUM = 6;
        if (pokemon.size() > 6) {
            return pokemon.subList(0, 6);
        }
        return pokemon;
    }
}

