/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.battle.predicate;

import java.time.Duration;
import java.time.Instant;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.player.PlayerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MessagePredicate;
import kiwiapollo.cobblemontrainerbattle.global.history.PlayerHistoryStorage;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class CooldownElapsedPredicate
implements MessagePredicate<PlayerBattleParticipant> {
    private final String trainer;
    private final long cooldown;
    private long remains;

    public CooldownElapsedPredicate(String trainer, long cooldown) {
        this.trainer = trainer;
        this.cooldown = cooldown;
    }

    @Override
    public class_5250 getErrorMessage() {
        return class_2561.method_43469((String)"predicate.cobblemontrainerbattle.error.cooldown_elapsed", (Object[])new Object[]{this.remains});
    }

    private long getRemainingCooldownInSeconds(PlayerBattleParticipant player) {
        Instant timestamp = PlayerHistoryStorage.getInstance().getOrCreate(player.getUuid()).getOrCreate(this.trainer).getTimestamp();
        long remains = this.cooldown - Duration.between(timestamp, Instant.now()).toSeconds();
        if (remains > 0L) {
            return remains;
        }
        return 0L;
    }

    @Override
    public boolean test(PlayerBattleParticipant player) {
        this.remains = this.getRemainingCooldownInSeconds(player);
        return this.remains == 0L;
    }
}

