/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.entity;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.battles.BattleRegistry;
import java.util.Objects;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.advancement.CustomCriteria;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.player.PlayerBattleParticipantFactory;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer.TrainerBattleParticipantFactory;
import kiwiapollo.cobblemontrainerbattle.battle.trainerbattle.EntityBackedTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.battle.trainerbattle.NullTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.battle.trainerbattle.TrainerBattle;
import kiwiapollo.cobblemontrainerbattle.common.LevelMode;
import kiwiapollo.cobblemontrainerbattle.entity.RandomSpawnableTrainerFactory;
import kiwiapollo.cobblemontrainerbattle.entity.TrainerEntityBehavior;
import kiwiapollo.cobblemontrainerbattle.entity.TrainerTexture;
import kiwiapollo.cobblemontrainerbattle.exception.BattleStartException;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContextStorage;
import kiwiapollo.cobblemontrainerbattle.global.history.PlayerHistory;
import kiwiapollo.cobblemontrainerbattle.global.history.PlayerHistoryStorage;
import kiwiapollo.cobblemontrainerbattle.global.history.TrainerRecord;
import kiwiapollo.cobblemontrainerbattle.global.preset.TrainerStorage;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5425;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public abstract class TrainerEntity
extends class_1314
implements TrainerEntityBehavior {
    public static final int FLEE_DISTANCE = 20;
    private static final String FALLBACK_TRAINER = "radicalred/player_red";
    private static final String FALLBACK_TEXTURE = TrainerTexture.RED.getIdentifier().toString();
    private static final class_2940<String> TRAINER = class_2945.method_12791(TrainerEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> TEXTURE = class_2945.method_12791(TrainerEntity.class, (class_2941)class_2943.field_13326);
    private static final String TRAINER_NBT_KEY = "Trainer";
    private TrainerBattle trainerBattle = new NullTrainerBattle();

    public TrainerEntity(class_1299<? extends class_1314> type, class_1937 world) {
        super(type, world);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        if (spawnReason.equals((Object)class_3730.field_16469)) {
            this.setTrainer(new RandomSpawnableTrainerFactory(trainer -> true).create());
        }
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TRAINER, (Object)FALLBACK_TRAINER);
        builder.method_56912(TEXTURE, (Object)FALLBACK_TEXTURE);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.method_37908().field_9236) {
            return class_1269.field_5812;
        }
        if (!(player instanceof class_3222)) {
            return class_1269.field_5814;
        }
        this.startTrainerBattle((class_3222)player, hand);
        return super.method_5992(player, hand);
    }

    private void startTrainerBattle(class_3222 player, class_1268 hand) {
        try {
            if (this.hasTrainerBattle()) {
                return;
            }
            EntityBackedTrainerBattle trainerBattle = new EntityBackedTrainerBattle(new PlayerBattleParticipantFactory(player, this.getLevelMode((String)this.method_5841().method_12789(TRAINER))).create(), new TrainerBattleParticipantFactory((String)this.method_5841().method_12789(TRAINER)).create(), (class_1309)this);
            trainerBattle.start();
            BattleContextStorage.getInstance().getOrCreate(player.method_5667()).setTrainerBattle(trainerBattle);
            this.trainerBattle = trainerBattle;
            this.method_18800(0.0, 0.0, 0.0);
            this.method_5977(true);
            this.field_6007 = true;
            class_174.field_25694.method_30097(player, player.method_5998(hand), (class_1297)this);
        }
        catch (BattleStartException battleStartException) {
            // empty catch block
        }
    }

    private LevelMode getLevelMode(String trainer) {
        return TrainerStorage.getInstance().get(trainer).getLevelMode();
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.hasTrainerBattle()) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    private boolean hasTrainerBattle() {
        try {
            UUID battleId = this.trainerBattle.getBattleId();
            Cobblemon.INSTANCE.getBattleRegistry();
            return Objects.nonNull(BattleRegistry.getBattle((UUID)battleId));
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public void method_6078(class_1282 damageSource) {
        class_1297 class_12972 = damageSource.method_5526();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            PlayerHistory history = PlayerHistoryStorage.getInstance().getOrCreate(player.method_5667());
            TrainerRecord record = history.getOrCreate((String)this.method_5841().method_12789(TRAINER));
            record.setKillCount(record.getKillCount() + 1);
            CustomCriteria.KILL_TRAINER_CRITERION.trigger(player);
        }
        if (this.hasTrainerBattle()) {
            UUID battleId = this.trainerBattle.getBattleId();
            Cobblemon.INSTANCE.getBattleRegistry();
            BattleRegistry.getBattle((UUID)battleId).end();
        }
        super.method_6078(damageSource);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582(TRAINER_NBT_KEY, (String)this.method_5841().method_12789(TRAINER));
    }

    public void method_5749(class_2487 nbt) {
        try {
            super.method_5749(nbt);
            this.setTrainer(nbt.method_10558(TRAINER_NBT_KEY));
        }
        catch (NullPointerException e) {
            this.method_31472();
        }
    }

    @Override
    public void setTrainer(String trainer) {
        this.method_5841().method_12778(TRAINER, (Object)trainer);
        this.method_5841().method_12778(TEXTURE, (Object)this.getTexture(trainer));
    }

    @Override
    public class_2960 getTexture() {
        String texture = (String)this.method_5841().method_12789(TEXTURE);
        return class_2960.method_12829((String)Objects.requireNonNull(texture));
    }

    @Nullable
    private String getTexture(String trainer) {
        try {
            return TrainerStorage.getInstance().get(trainer).getTexture().toString();
        }
        catch (NullPointerException e) {
            return FALLBACK_TEXTURE;
        }
    }

    @Override
    public void onPlayerVictory() {
    }

    @Override
    public void onPlayerDefeat() {
        this.method_5977(false);
    }

    protected void dropDefeatedInBattleLoot() {
        class_52 lootTable = this.method_37908().method_8503().method_58576().method_58295(this.method_5989());
        class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1231, (Object)this.method_37908().method_48963().method_48830());
        class_8567 lootContextParameterSet = builder.method_51875(class_173.field_1173);
        lootTable.method_51880(lootContextParameterSet, this.method_51851(), arg_0 -> ((TrainerEntity)this).method_5775(arg_0));
    }

    @Override
    public TrainerBattle getTrainerBattle() {
        UUID battleId = this.trainerBattle.getBattleId();
        Cobblemon.INSTANCE.getBattleRegistry();
        Objects.requireNonNull(BattleRegistry.getBattle((UUID)battleId));
        return this.trainerBattle;
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1314.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23719, 0.25);
    }
}

