/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.global.history;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.CobblemonTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.global.history.PlayerHistory;
import kiwiapollo.cobblemontrainerbattle.global.history.PlayerHistoryStorage;
import kiwiapollo.cobblemontrainerbattle.global.history.PlayerHistoryUtil;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.server.MinecraftServer;

public class PlayerHistoryLoader
implements ServerLifecycleEvents.ServerStarted {
    public void onServerStarted(MinecraftServer server) {
        File historyPath = PlayerHistoryUtil.getHistoryPath(server);
        if (!historyPath.isDirectory()) {
            return;
        }
        PlayerHistoryStorage.getInstance().clear();
        List<File> datFileList = Arrays.stream(historyPath.listFiles()).filter(this::isDatFile).toList();
        for (File file : datFileList) {
            try {
                UUID uuid = UUID.fromString(file.getName().replace(".dat", ""));
                PlayerHistory history = new PlayerHistory();
                history.readFromNbt(class_2507.method_30613((Path)file.toPath(), (class_2505)class_2505.method_53898()));
                PlayerHistoryStorage.getInstance().put(uuid, history);
            }
            catch (IOException | NullPointerException e) {
                UUID uuid = UUID.fromString(file.getName().replace(".dat", ""));
                File backup = new File(historyPath, String.format("%s.dat_bak", uuid));
                file.renameTo(backup);
                PlayerHistory history = new PlayerHistory();
                PlayerHistoryStorage.getInstance().put(uuid, history);
                CobblemonTrainerBattle.LOGGER.error("Error occurred while loading {}", (Object)file.getName());
                CobblemonTrainerBattle.LOGGER.error("Created backup : {}", (Object)backup.getName());
            }
        }
        CobblemonTrainerBattle.LOGGER.info("Loaded player histories");
    }

    private boolean isDatFile(File file) {
        return file.getName().endsWith(".dat");
    }
}

