/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.item;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import kiwiapollo.cobblemontrainerbattle.item.LegacyJsonPokemon15;
import kiwiapollo.cobblemontrainerbattle.item.LegacyJsonPokemon16;

public class JsonPokemon {
    @SerializedName(value="Species")
    public String species;
    @SerializedName(value="Level")
    public int level;
    @SerializedName(value="Ability")
    public Map<String, Object> ability;
    @SerializedName(value="Nature")
    public String nature;
    @SerializedName(value="MoveSet")
    public List<Map<String, Object>> moves;
    @SerializedName(value="IVs")
    public Map<String, Map<String, Integer>> ivs;
    @SerializedName(value="EVs")
    public Map<String, Integer> evs;

    public JsonPokemon(LegacyJsonPokemon15 pokemon) {
        this.species = pokemon.species;
        this.level = pokemon.level;
        this.ability = pokemon.ability;
        this.nature = pokemon.nature;
        this.moves = this.fromLegacyMoves(pokemon.moves);
        this.ivs = this.fromLegacyIV15(pokemon.ivs);
        this.evs = this.fromLegacyEV15(pokemon.evs);
    }

    public JsonPokemon(LegacyJsonPokemon16 pokemon) {
        this.species = pokemon.species;
        this.level = pokemon.level;
        this.ability = pokemon.ability;
        this.nature = pokemon.nature;
        this.moves = pokemon.moves;
        this.ivs = this.fromLegacyIV16(pokemon.ivs);
        this.evs = pokemon.evs;
    }

    private List<Map<String, Object>> fromLegacyMoves(Map<String, Map<String, Object>> moves) {
        return moves.values().stream().toList();
    }

    private Map<String, Integer> fromLegacyEV15(Map<String, Integer> evs) {
        return Map.of("cobblemon:hp", evs.getOrDefault("hp", 0), "cobblemon:attack", evs.getOrDefault("attack", 0), "cobblemon:defence", evs.getOrDefault("defence", 0), "cobblemon:special_attack", evs.getOrDefault("special_attack", 0), "cobblemon:special_defence", evs.getOrDefault("special_defence", 0), "cobblemon:speed", evs.getOrDefault("speed", 0));
    }

    private Map<String, Map<String, Integer>> fromLegacyIV15(Map<String, Integer> ivs) {
        return Map.ofEntries(Map.entry("Base", Map.of("cobblemon:hp", ivs.getOrDefault("hp", 0), "cobblemon:attack", ivs.getOrDefault("attack", 0), "cobblemon:defence", ivs.getOrDefault("defence", 0), "cobblemon:special_attack", ivs.getOrDefault("special_attack", 0), "cobblemon:special_defence", ivs.getOrDefault("special_defence", 0), "cobblemon:speed", ivs.getOrDefault("speed", 0))), Map.entry("HyperTrained", Map.of("cobblemon:hp", 0, "cobblemon:attack", 0, "cobblemon:defence", 0, "cobblemon:special_attack", 0, "cobblemon:special_defence", 0, "cobblemon:speed", 0)));
    }

    private Map<String, Map<String, Integer>> fromLegacyIV16(Map<String, Integer> ivs) {
        return Map.ofEntries(Map.entry("Base", ivs), Map.entry("HyperTrained", Map.of("cobblemon:hp", 0, "cobblemon:attack", 0, "cobblemon:defence", 0, "cobblemon:special_attack", 0, "cobblemon:special_defence", 0, "cobblemon:speed", 0)));
    }
}

