/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.pokemon;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import kiwiapollo.cobblemontrainerbattle.CobblemonTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.exception.PokemonParseException;
import kiwiapollo.cobblemontrainerbattle.pokemon.ShowdownMoveParser;
import kiwiapollo.cobblemontrainerbattle.pokemon.ShowdownPokemon;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ShowdownPokemonParser {
    public static final int DEFAULT_LEVEL = 50;
    private static final Map<String, Set<String>> FORM_ASPECTS = Map.ofEntries(Map.entry("Normal", Set.of()), Map.entry("Alola", Set.of("alolan")), Map.entry("Alola Bias", Set.of("region-bias-alola")), Map.entry("Galar", Set.of("galarian")), Map.entry("Galar Bias", Set.of("region-bias-galar")), Map.entry("Hisui", Set.of("hisuian")), Map.entry("Hisui Bias", Set.of("region-bias-hisui")), Map.entry("Paldea", Set.of("paldean")), Map.entry("Paldea Bias", Set.of("region-bias-paldea")), Map.entry("Paldea-Aqua", Set.of("aqua-breed")), Map.entry("Paldea-Blaze", Set.of("blaze-breed")), Map.entry("Paldea-Combat", Set.of("combat-breed")), Map.entry("Therian", Set.of("therian")), Map.entry("Zen", Set.of("zen_mode")), Map.entry("Galar-Zen", Set.of("galarian", "zen_mode")), Map.entry("Heat", Set.of("heat-appliance")), Map.entry("Wash", Set.of("wash-appliance")), Map.entry("Frost", Set.of("frost-appliance")), Map.entry("Fan", Set.of("fan-appliance")), Map.entry("Mow", Set.of("mow-appliance")));

    public Pokemon toCobblemonPokemon(ShowdownPokemon showdownPokemon) throws PokemonParseException {
        Pokemon pokemon = this.createBasePokemon(showdownPokemon);
        this.setPokemonForm(pokemon, this.getFormName(showdownPokemon.species, showdownPokemon.form));
        this.setPokemonShiny(pokemon, showdownPokemon.shiny);
        this.setPokemonStats((arg_0, arg_1) -> ((Pokemon)pokemon).setEV(arg_0, arg_1), showdownPokemon.evs);
        this.setPokemonStats((arg_0, arg_1) -> ((Pokemon)pokemon).setIV(arg_0, arg_1), showdownPokemon.ivs);
        this.setPokemonGender(pokemon, showdownPokemon.gender);
        this.setPokemonMoveSet(pokemon, showdownPokemon.moves);
        this.setPokemonHeldItem(pokemon, showdownPokemon.item);
        this.setPokemonAbility(pokemon, showdownPokemon.ability);
        this.setPokemonLevel(pokemon, showdownPokemon.level);
        this.setPokemonNature(pokemon, showdownPokemon.nature);
        this.setPokemonUncatchable(pokemon);
        return pokemon;
    }

    private Pokemon createBasePokemon(ShowdownPokemon pokemon) throws PokemonParseException {
        try {
            return ShowdownPokemonParser.toSpecies(pokemon).create(50);
        }
        catch (ClassCastException | NullPointerException e) {
            throw new PokemonParseException();
        }
    }

    private void setPokemonForm(Pokemon pokemon, String form) {
        pokemon.getSpecies().getForms().stream().filter(formData -> formData.getName().equals(form)).findFirst().ifPresent(formData -> pokemon.setForcedAspects(new HashSet(formData.getAspects())));
    }

    private String getFormName(String species, String form) {
        return FORM_ASPECTS.keySet().stream().filter(species::contains).findFirst().orElse(form);
    }

    private void setPokemonShiny(Pokemon pokemon, boolean shiny) {
        pokemon.setShiny(shiny);
    }

    protected void setPokemonLevel(Pokemon pokemon, int level) {
        pokemon.setLevel(level);
    }

    private void setPokemonAbility(Pokemon pokemon, String ability) {
        try {
            pokemon.updateAbility(Abilities.getOrException((String)ShowdownPokemonParser.toAbilityName(ability)).create(false, Priority.LOWEST));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    private void setPokemonStats(BiConsumer<Stats, Integer> consumer, Map<String, Integer> stats) {
        if (Objects.isNull(stats)) {
            return;
        }
        if (stats.containsKey("hp")) {
            consumer.accept(Stats.HP, stats.get("hp"));
        }
        if (stats.containsKey("atk")) {
            consumer.accept(Stats.ATTACK, stats.get("atk"));
        }
        if (stats.containsKey("def")) {
            consumer.accept(Stats.DEFENCE, stats.get("def"));
        }
        if (stats.containsKey("spa")) {
            consumer.accept(Stats.SPECIAL_ATTACK, stats.get("spa"));
        }
        if (stats.containsKey("spd")) {
            consumer.accept(Stats.SPECIAL_DEFENCE, stats.get("spd"));
        }
        if (stats.containsKey("spe")) {
            consumer.accept(Stats.SPEED, stats.get("spe"));
        }
    }

    private void setPokemonNature(Pokemon pokemon, String nature) {
        try {
            class_2960 identifier = ShowdownPokemonParser.toNatureIdentifier(Objects.requireNonNull(nature));
            pokemon.setNature(Objects.requireNonNull(Natures.getNature((class_2960)identifier)));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void setPokemonGender(Pokemon pokemon, String gender) {
        try {
            pokemon.setGender(this.toGender(gender));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    private Gender toGender(String gender) throws IllegalArgumentException {
        return switch (gender) {
            case "M" -> Gender.MALE;
            case "F" -> Gender.FEMALE;
            case "N" -> Gender.GENDERLESS;
            default -> throw new IllegalArgumentException();
        };
    }

    private void setPokemonHeldItem(Pokemon pokemon, String item) {
        try {
            pokemon.swapHeldItem(this.toHeldItem(item), false, false);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private class_1799 toHeldItem(String item) {
        class_2960 identifier = ShowdownPokemonParser.toHeldItemIdentifier(item);
        return new class_1799((class_1935)class_7923.field_41178.method_10223(identifier));
    }

    private void setPokemonMoveSet(Pokemon pokemon, List<String> moves) {
        List<String> filtered = moves.stream().filter(move -> !new ShowdownMoveParser().shouldIgnore((String)move)).toList();
        if (this.shouldUseDefaultMoveSet(filtered)) {
            return;
        }
        pokemon.getMoveSet().clear();
        for (String move2 : filtered) {
            try {
                pokemon.getMoveSet().add(Moves.getByName((String)new ShowdownMoveParser().toCobblemonMove(move2)).create());
            }
            catch (NullPointerException e) {
                CobblemonTrainerBattle.LOGGER.error("Move not found: {}", (Object)move2);
            }
        }
    }

    private void setPokemonUncatchable(Pokemon pokemon) {
        PokemonProperties.Companion.parse("uncatchable=yes").apply(pokemon);
    }

    private boolean shouldUseDefaultMoveSet(List<String> moves) {
        return moves == null || moves.isEmpty();
    }

    public static Species toSpecies(ShowdownPokemon pokemon) {
        String string = ShowdownPokemonParser.removeFormName(pokemon.species);
        class_2960 identifier = ShowdownPokemonParser.toSpeciesIdentifier(string);
        return PokemonSpecies.getByIdentifier((class_2960)identifier);
    }

    private static class_2960 toSpeciesIdentifier(String string) {
        if (string.contains(String.valueOf(':'))) {
            return class_2960.method_12829((String)string);
        }
        String path = string;
        path = path.toLowerCase();
        path = path.replaceAll("[^a-z0-9_:]", "");
        return class_2960.method_60655((String)"cobblemon", (String)path);
    }

    private static class_2960 toNatureIdentifier(String string) {
        if (string.contains(String.valueOf(':'))) {
            return class_2960.method_12829((String)string);
        }
        String path = string;
        path = path.toLowerCase();
        path = path.replaceAll("[^a-z0-9_:]", "");
        return class_2960.method_60655((String)"cobblemon", (String)path);
    }

    private static class_2960 toHeldItemIdentifier(String string) {
        if (string.contains(String.valueOf(':'))) {
            return class_2960.method_12829((String)string);
        }
        String path = string;
        path = path.toLowerCase();
        path = path.replace(" ", "_");
        path = path.replaceAll("[^a-z0-9_:]", "");
        return class_2960.method_60655((String)"cobblemon", (String)path);
    }

    private static String removeFormName(String species) {
        String s = species;
        for (String form : FORM_ASPECTS.keySet()) {
            s = s.replaceAll(form, "");
        }
        return s;
    }

    private static String toAbilityName(String ability) {
        String name = ability;
        name = name.toLowerCase();
        name = name.replaceAll("[^a-z0-9_:]", "");
        return name;
    }
}

