/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.global.history;

import java.time.Instant;
import kiwiapollo.cobblemontrainerbattle.global.history.BattleRecord;
import kiwiapollo.cobblemontrainerbattle.global.history.EntityRecord;
import kiwiapollo.cobblemontrainerbattle.global.history.NbtConvertible;
import net.minecraft.class_2487;

public class TrainerRecord
implements NbtConvertible,
BattleRecord,
EntityRecord {
    private Instant timestamp = Instant.EPOCH;
    private int victory = 0;
    private int defeat = 0;
    private int kill = 0;

    @Override
    public int getVictoryCount() {
        return this.victory;
    }

    @Override
    public void setVictoryCount(int count) {
        this.victory = count;
        this.updateTimestamp();
    }

    @Override
    public int getDefeatCount() {
        return this.defeat;
    }

    @Override
    public void setDefeatCount(int count) {
        this.defeat = count;
        this.updateTimestamp();
    }

    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getKillCount() {
        return this.kill;
    }

    @Override
    public void setKillCount(int count) {
        this.kill = count;
    }

    @Override
    public void readFromNbt(class_2487 nbt) {
        this.timestamp = Instant.ofEpochMilli(nbt.method_10537("timestamp"));
        this.victory = nbt.method_10550("victory");
        this.defeat = nbt.method_10550("defeat");
        this.kill = nbt.method_10550("kill");
    }

    @Override
    public class_2487 writeToNbt(class_2487 nbt) {
        nbt.method_10544("timestamp", this.timestamp.toEpochMilli());
        nbt.method_10569("victory", this.victory);
        nbt.method_10569("defeat", this.defeat);
        nbt.method_10569("kill", this.kill);
        return nbt;
    }

    private void updateTimestamp() {
        this.timestamp = Instant.now();
    }
}

