/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.item;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kiwiapollo.cobblemontrainerbattle.item.FilledPokeBall;
import kiwiapollo.cobblemontrainerbattle.item.JsonPokemon;
import kiwiapollo.cobblemontrainerbattle.item.LegacyJsonPokemon;
import kiwiapollo.cobblemontrainerbattle.item.PokeBallComponent;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class FilledPokeBallPokemonParser {
    public Pokemon toPokemon(class_1799 stack) {
        if (!(stack.method_7909() instanceof FilledPokeBall)) {
            throw new IllegalArgumentException();
        }
        JsonObject jsonObject = JsonParser.parseString((String)Objects.requireNonNull((String)stack.method_57824(PokeBallComponent.POKEMON))).getAsJsonObject();
        JsonPokemon jsonPokemon = this.getJsonPokemon(jsonObject);
        Pokemon pokemon = new Pokemon();
        pokemon.setSpecies(this.getSpecies(jsonPokemon));
        pokemon.setLevel(this.getLevel(jsonPokemon));
        pokemon.setAbility$common(this.getAbility(jsonPokemon));
        pokemon.setNature(this.getNature(jsonPokemon));
        pokemon.getMoveSet().clear();
        this.getMoves(jsonPokemon).forEach(m -> pokemon.getMoveSet().add(m));
        this.getIVs(jsonPokemon).forEach((arg_0, arg_1) -> ((Pokemon)pokemon).setIV(arg_0, arg_1));
        this.getEVs(jsonPokemon).forEach((arg_0, arg_1) -> ((Pokemon)pokemon).setEV(arg_0, arg_1));
        return pokemon;
    }

    private JsonPokemon getJsonPokemon(JsonObject jsonObject) {
        try {
            return (JsonPokemon)new Gson().fromJson((JsonElement)jsonObject, JsonPokemon.class);
        }
        catch (JsonSyntaxException e) {
            return this.toJsonPokemon((LegacyJsonPokemon)new Gson().fromJson((JsonElement)jsonObject, LegacyJsonPokemon.class));
        }
    }

    private JsonPokemon toJsonPokemon(LegacyJsonPokemon legacy) {
        return new JsonPokemon(legacy);
    }

    private Species getSpecies(JsonPokemon pokemon) {
        return PokemonSpecies.getByIdentifier((class_2960)class_2960.method_60654((String)pokemon.species));
    }

    private int getLevel(JsonPokemon pokemon) {
        return pokemon.level;
    }

    private Ability getAbility(JsonPokemon pokemon) {
        return Abilities.getOrException((String)((String)pokemon.ability.get("AbilityName"))).create(true, Priority.LOW);
    }

    private Nature getNature(JsonPokemon pokemon) {
        return Natures.getNature((class_2960)class_2960.method_60654((String)pokemon.nature));
    }

    private List<Move> getMoves(JsonPokemon pokemon) {
        return pokemon.moves.stream().map(move -> (String)move.get("MoveName")).map(move -> Moves.getByName((String)move).create()).toList();
    }

    private Map<Stats, Integer> getIVs(JsonPokemon pokemon) {
        return this.getStats(pokemon.ivs);
    }

    private Map<Stats, Integer> getEVs(JsonPokemon pokemon) {
        return this.getStats(pokemon.evs);
    }

    private Map<Stats, Integer> getStats(Map<String, Integer> stats) {
        return Map.of(Stats.HP, stats.getOrDefault("cobblemon:hp", 0), Stats.ATTACK, stats.getOrDefault("cobblemon:attack", 0), Stats.DEFENCE, stats.getOrDefault("cobblemon:defence", 0), Stats.SPECIAL_ATTACK, stats.getOrDefault("cobblemon:special_attack", 0), Stats.SPECIAL_DEFENCE, stats.getOrDefault("cobblemon:special_defence", 0), Stats.SPEED, stats.getOrDefault("cobblemon:speed", 0));
    }
}

