/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.item;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import kiwiapollo.cobblemontrainerbattle.item.LegacyJsonPokemon;

public class JsonPokemon {
    @SerializedName(value="Species")
    public String species;
    @SerializedName(value="Level")
    public int level;
    @SerializedName(value="Ability")
    public Map<String, Object> ability;
    @SerializedName(value="Nature")
    public String nature;
    @SerializedName(value="MoveSet")
    public List<Map<String, Object>> moves;
    @SerializedName(value="IVs")
    public Map<String, Integer> ivs;
    @SerializedName(value="EVs")
    public Map<String, Integer> evs;

    public JsonPokemon(LegacyJsonPokemon pokemon) {
        this.species = pokemon.species;
        this.level = pokemon.level;
        this.ability = pokemon.ability;
        this.nature = pokemon.nature;
        this.moves = this.fromLegacyMoves(pokemon.moves);
        this.ivs = this.fromLegacyStats(pokemon.ivs);
        this.evs = this.fromLegacyStats(pokemon.evs);
    }

    private List<Map<String, Object>> fromLegacyMoves(Map<String, Map<String, Object>> moves) {
        return moves.values().stream().toList();
    }

    private Map<String, Integer> fromLegacyStats(Map<String, Integer> stats) {
        return Map.of("cobblemon:hp", stats.getOrDefault("hp", 0), "cobblemon:attack", stats.getOrDefault("attack", 0), "cobblemon:defence", stats.getOrDefault("defence", 0), "cobblemon:special_attack", stats.getOrDefault("special_attack", 0), "cobblemon:special_defence", stats.getOrDefault("special_defence", 0), "cobblemon:speed", stats.getOrDefault("speed", 0));
    }
}

