/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.mixin;

import com.cobblemon.mod.common.api.drop.DropTable;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContext;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContextStorage;
import kotlin.ranges.IntRange;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DropTable.class})
public class DropTableMixin {
    @Inject(method={"drop"}, at={@At(value="HEAD")}, cancellable=true)
    public void cancelDrop(class_1309 entity, class_3218 world, class_243 pos, class_3222 player, IntRange amount, Pokemon pokemon, CallbackInfo callbackInfo) {
        if (this.isTrainerBattle(entity, world)) {
            callbackInfo.cancel();
        }
    }

    private boolean isTrainerBattle(class_1309 entity, class_3218 world) {
        try {
            PokemonEntity pokemon = (PokemonEntity)entity;
            return this.getTrainerBattleIds(world).contains(pokemon.getBattleId());
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    private List<UUID> getTrainerBattleIds(class_3218 world) {
        ArrayList<UUID> battleIds = new ArrayList<UUID>();
        for (class_3222 player : world.method_18456()) {
            try {
                BattleContext context = BattleContextStorage.getInstance().getOrCreate(player.method_5667());
                battleIds.add(context.getTrainerBattle().getBattleId());
            }
            catch (NullPointerException nullPointerException) {}
        }
        return battleIds;
    }
}

