/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.battle.predicate;

import com.cobblemon.mod.common.battles.BattleFormat;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.player.PlayerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MessagePredicate;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class MinimumPartySizePredicate
implements MessagePredicate<Integer> {
    private final int required;

    private MinimumPartySizePredicate(int required) {
        this.required = required;
    }

    @Override
    public class_5250 getErrorMessage() {
        return class_2561.method_43469((String)"predicate.cobblemontrainerbattle.error.minimum_party_size", (Object[])new Object[]{this.required});
    }

    @Override
    public boolean test(Integer size) {
        return size >= this.required;
    }

    public static class ValuePredicate
    implements MessagePredicate<Integer> {
        private final MinimumPartySizePredicate predicate;

        public ValuePredicate(BattleFormat format) {
            this(format.getBattleType().getSlotsPerActor());
        }

        public ValuePredicate(int required) {
            this.predicate = new MinimumPartySizePredicate(required);
        }

        @Override
        public boolean test(Integer required) {
            return this.predicate.test(required);
        }

        @Override
        public class_5250 getErrorMessage() {
            return this.predicate.getErrorMessage();
        }
    }

    public static class PlayerPredicate
    implements MessagePredicate<PlayerBattleParticipant> {
        private final MinimumPartySizePredicate predicate;

        public PlayerPredicate(BattleFormat format) {
            this(format.getBattleType().getSlotsPerActor());
        }

        public PlayerPredicate(int required) {
            this.predicate = new MinimumPartySizePredicate(required);
        }

        @Override
        public boolean test(PlayerBattleParticipant player) {
            return this.predicate.test(player.getParty().occupied());
        }

        @Override
        public class_5250 getErrorMessage() {
            return this.predicate.getErrorMessage();
        }
    }
}

