/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.command.executor;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import kiwiapollo.cobblemontrainerbattle.CobblemonTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.player.NormalLevelPlayer;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.PlayerPartyNotEmptyPredicate;
import kiwiapollo.cobblemontrainerbattle.pokemon.CobblemonPokemonParser;
import kiwiapollo.cobblemontrainerbattle.pokemon.ShowdownPokemon;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class ShowdownPokemonExporter
implements Command<class_2168> {
    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            class_3222 player = class_2186.method_9315(context, (String)"player");
            PlayerPartyNotEmptyPredicate predicate = new PlayerPartyNotEmptyPredicate();
            if (!predicate.test(new NormalLevelPlayer(player))) {
                player.method_43496((class_2561)predicate.getErrorMessage());
                return 0;
            }
            File exportPath = this.getExportPath(player.method_5682());
            if (!exportPath.exists()) {
                exportPath.mkdirs();
            }
            this.writeJsonFile(player);
            player.method_43496((class_2561)class_2561.method_43469((String)"command.cobblemontrainerbattle.success.export", (Object[])new Object[]{player.method_7334().getName()}));
            CobblemonTrainerBattle.LOGGER.error("Exported Pok\u00e9mon : {}", (Object)player.method_7334().getName());
            return 1;
        }
        catch (CommandSyntaxException | IOException e) {
            CobblemonTrainerBattle.LOGGER.error("Error occurred while exporting trainer file");
            return 0;
        }
    }

    private File getExportPath(MinecraftServer server) {
        String exportDir = "export";
        File worldDir = server.method_27050(class_5218.field_24188).toFile();
        String exportPath = "cobblemontrainerbattle/export";
        return new File(worldDir, exportPath);
    }

    private void writeJsonFile(class_3222 player) throws IOException {
        try (FileWriter fileWriter = new FileWriter(this.getExportFile(player));){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson(new Gson().toJsonTree(this.getShowdownPokemon(player)), (Appendable)fileWriter);
        }
    }

    private List<ShowdownPokemon> getShowdownPokemon(class_3222 player) {
        List<Pokemon> pokemons = Cobblemon.INSTANCE.getStorage().getParty(player).toGappyList().stream().filter(Objects::nonNull).toList();
        return pokemons.stream().map(new CobblemonPokemonParser()::toShowdownPokemon).toList();
    }

    private File getExportFile(class_3222 player) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.now(), ZoneId.systemDefault());
        String timestamp = dateTime.format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
        String exportFileName = String.format("%s_%s.json", player.method_7334().getName().toLowerCase(), timestamp);
        return new File(this.getExportPath(player.method_5682()), exportFileName);
    }
}

