/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.event;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.FleeableBattleActor;
import com.cobblemon.mod.common.battles.BattleRegistry;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.stream.StreamSupport;
import kiwiapollo.cobblemontrainerbattle.battle.trainerbattle.TrainerBattle;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContextStorage;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class TrainerBattleFledEventHandler
implements ServerTickEvents.EndWorldTick {
    public void onEndTick(class_3218 world) {
        List<class_3222> players = world.method_18456().stream().filter(this::isFledFromTrainerBattle).toList();
        players.stream().map(this::getTrainerBattle).forEach(TrainerBattle::onPlayerDefeat);
        players.stream().map(this::getPokemonBattle).forEach(PokemonBattle::end);
    }

    private boolean isFledFromTrainerBattle(class_3222 player) {
        try {
            PokemonBattle battle = this.getPokemonBattle(player);
            FleeableBattleActor trainer = this.getFleeableBattleActors(battle).get(0);
            class_243 playerPos = player.method_19538();
            class_243 trainerPos = (class_243)trainer.getWorldAndPosition().getSecond();
            return playerPos.method_1022(trainerPos) > (double)trainer.getFleeDistance();
        }
        catch (IndexOutOfBoundsException | NullPointerException | NoSuchElementException e) {
            return false;
        }
    }

    private TrainerBattle getTrainerBattle(class_3222 player) {
        return BattleContextStorage.getInstance().getOrCreate(player.method_5667()).getTrainerBattle();
    }

    private PokemonBattle getPokemonBattle(class_3222 player) {
        UUID battleId = this.getTrainerBattle(player).getBattleId();
        Cobblemon.INSTANCE.getBattleRegistry();
        return BattleRegistry.getBattle((UUID)battleId);
    }

    private List<FleeableBattleActor> getFleeableBattleActors(PokemonBattle battle) {
        return StreamSupport.stream(battle.getActors().spliterator(), false).filter(actor -> actor instanceof FleeableBattleActor).map(actor -> (FleeableBattleActor)actor).toList();
    }
}

