/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import kiwiapollo.cobblemontrainerbattle.CobblemonTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.entity.TrainerEntity;
import kiwiapollo.cobblemontrainerbattle.event.EntityCounter;
import kiwiapollo.cobblemontrainerbattle.event.WeightedEntitySpawner;
import kiwiapollo.cobblemontrainerbattle.item.VsSeeker;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;

public abstract class TrainerEntitySpawner
implements WeightedEntitySpawner,
EntityCounter {
    protected static final int MAXIMUM_RADIUS = 30;
    protected static final int MINIMUM_RADIUS = 5;

    @Override
    public void spawnEntity(class_3218 world, class_3222 player) {
        try {
            TrainerEntity entity = this.createTrainerEntity(world, player);
            class_2338 spawnPos = this.getRandomSpawnPosition(world, (class_1657)player);
            entity.method_5725(spawnPos, player.method_36454(), player.method_36455());
            world.method_8649((class_1297)entity);
            CobblemonTrainerBattle.LOGGER.info("Spawned {} at {} {}", new Object[]{entity.method_5476().getString(), world.method_27983().method_29177(), spawnPos});
        }
        catch (ClassCastException | IllegalStateException runtimeException) {
            // empty catch block
        }
    }

    protected abstract TrainerEntity createTrainerEntity(class_3218 var1, class_3222 var2);

    protected Predicate<String> toPredicate(class_1661 inventory) {
        ArrayList<Predicate<String>> predicates = new ArrayList<Predicate<String>>();
        predicates.add(trainer -> false);
        predicates.addAll(VsSeeker.getVsSeekers(inventory));
        return predicates.stream().reduce(Predicate::or).orElse(t -> true);
    }

    private class_2338 getRandomSpawnPosition(class_3218 world, class_1657 player) throws IllegalStateException {
        class_2338 playerPos = player.method_24515();
        int MAXIMUM_RETRIES = 50;
        for (int i = 0; i < 50; ++i) {
            int xOffset = class_5819.method_43047().method_39332(5, 30) * this.getRandomSign();
            int zOffset = class_5819.method_43047().method_39332(5, 30) * this.getRandomSign();
            int yOffset = class_5819.method_43047().method_39332(-30, 30);
            class_2338 spawnPos = playerPos.method_10069(xOffset, yOffset, zOffset);
            boolean isSolidGround = world.method_8320(spawnPos.method_10074()).method_26212((class_1922)world, spawnPos.method_10074());
            boolean isEmptySpace = world.method_8320(spawnPos).method_26215();
            if (!isSolidGround || !isEmptySpace) continue;
            return spawnPos;
        }
        throw new IllegalStateException();
    }

    private int getRandomSign() {
        ArrayList<Integer> random = new ArrayList<Integer>(List.of(Integer.valueOf(-1), Integer.valueOf(1)));
        Collections.shuffle(random);
        return (Integer)random.get(0);
    }
}

