/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.global.context;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.common.LazyMap;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContext;

public class BattleContextStorage
implements LazyMap<UUID, BattleContext> {
    static BattleContextStorage instance;
    private Map<UUID, BattleContext> storage = new HashMap<UUID, BattleContext>();

    public static BattleContextStorage getInstance() {
        if (instance == null) {
            instance = new BattleContextStorage();
        }
        return instance;
    }

    private BattleContextStorage() {
    }

    @Override
    public BattleContext getOrCreate(UUID uuid) {
        if (!this.storage.containsKey(uuid)) {
            this.storage.put(uuid, new BattleContext());
        }
        return this.storage.get(uuid);
    }

    @Override
    public void put(UUID uuid, BattleContext context) {
        this.storage.put(uuid, context);
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    @Override
    public void remove(UUID uuid) {
        this.storage.remove(uuid);
    }

    @Override
    public Iterable<? extends Map.Entry<UUID, BattleContext>> entrySet() {
        return this.storage.entrySet();
    }
}

