/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.global.history;

import java.util.HashMap;
import java.util.Map;
import kiwiapollo.cobblemontrainerbattle.common.LazyMap;
import kiwiapollo.cobblemontrainerbattle.global.history.EntityRecord;
import kiwiapollo.cobblemontrainerbattle.global.history.NbtConvertible;
import kiwiapollo.cobblemontrainerbattle.global.history.RecordStatisticsProvider;
import kiwiapollo.cobblemontrainerbattle.global.history.TrainerRecord;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class PlayerHistory
implements NbtConvertible,
RecordStatisticsProvider,
LazyMap<String, TrainerRecord> {
    private final Map<String, TrainerRecord> records = new HashMap<String, TrainerRecord>();

    @Override
    public TrainerRecord getOrCreate(String trainer) {
        if (!this.records.containsKey(trainer)) {
            this.records.put(trainer, new TrainerRecord());
        }
        return this.records.get(trainer);
    }

    @Override
    public void put(String trainer, TrainerRecord record) {
        this.records.put(trainer, record);
    }

    @Override
    public void clear() {
        this.records.clear();
    }

    @Override
    public void remove(String trainer) {
        this.records.remove(trainer);
    }

    @Override
    public Iterable<? extends Map.Entry<String, TrainerRecord>> entrySet() {
        return this.records.entrySet();
    }

    @Override
    public int getTotalTrainerVictoryCount() {
        return this.records.values().stream().filter(record -> record instanceof TrainerRecord).map(record -> record).map(TrainerRecord::getVictoryCount).reduce(Integer::sum).orElse(0);
    }

    @Override
    public int getTotalTrainerKillCount() {
        return this.records.values().stream().filter(record -> record instanceof EntityRecord).map(record -> record).map(EntityRecord::getKillCount).reduce(Integer::sum).orElse(0);
    }

    @Override
    public void readFromNbt(class_2487 nbt) {
        this.records.clear();
        for (String trainer : nbt.method_10541()) {
            try {
                TrainerRecord record = new TrainerRecord();
                record.readFromNbt(nbt.method_10562(trainer));
                this.records.put(this.toNonLegacyTrainer(trainer), record);
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {}
        }
    }

    private String toNonLegacyTrainer(String trainer) {
        return trainer.replace("^trainer:", "");
    }

    @Override
    public class_2487 writeToNbt(class_2487 nbt) {
        this.records.forEach((identifier, record) -> nbt.method_10566(identifier, (class_2520)this.toNbtCompound((NbtConvertible)record)));
        return nbt;
    }

    private class_2487 toNbtCompound(NbtConvertible record) {
        class_2487 nbt = new class_2487();
        record.writeToNbt(nbt);
        return nbt;
    }
}

