/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.global.preset;

import com.cobblemon.mod.common.battles.BattleFormat;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kiwiapollo.cobblemontrainerbattle.CobblemonTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.BattleFormatFactory;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer.TrainerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MinimumPartySizePredicate;
import kiwiapollo.cobblemontrainerbattle.common.ImmutableMap;
import kiwiapollo.cobblemontrainerbattle.global.preset.TrainerBattleParticipantFactory;
import kiwiapollo.cobblemontrainerbattle.global.preset.TrainerPreset;
import kiwiapollo.cobblemontrainerbattle.pokemon.ShowdownPokemon;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class TrainerStorage
implements SimpleSynchronousResourceReloadListener,
ImmutableMap<String, TrainerBattleParticipant> {
    private static final String TEAM_DIR = "trainer_team";
    private static final String PRESET_DIR = "trainer_preset";
    private static final Gson GSON = new Gson();
    private static TrainerStorage instance;
    private final Map<String, TrainerBattleParticipant> storage = new HashMap<String, TrainerBattleParticipant>();

    private TrainerStorage() {
    }

    public static TrainerStorage getInstance() {
        if (instance == null) {
            instance = new TrainerStorage();
        }
        return instance;
    }

    @Override
    public TrainerBattleParticipant get(String trainer) {
        return this.storage.get(trainer);
    }

    @Override
    public Set<String> keySet() {
        return this.storage.keySet();
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"cobblemontrainerbattle", (String)"trainer_storage");
    }

    public Collection<class_2960> getFabricDependencies() {
        return List.of(class_2960.method_60655((String)"cobblemon", (String)"data_resources"));
    }

    public void method_14491(class_3300 manager) {
        Map<String, List<ShowdownPokemon>> teams = this.reloadTrainerTeam(manager);
        Map<class_2960, TrainerPreset> presets = this.reloadTrainerPreset(manager);
        this.storage.clear();
        for (Map.Entry<class_2960, TrainerPreset> trainer : presets.entrySet()) {
            List<ShowdownPokemon> team;
            if (!this.isValidTrainer(trainer, team = teams.getOrDefault(this.toTeamId(trainer.getValue().team), List.of()))) {
                CobblemonTrainerBattle.LOGGER.error("Invalid trainer preset : {}", (Object)this.toSimplePath(trainer));
                continue;
            }
            this.storage.put(this.toTrainerId(trainer), new TrainerBattleParticipantFactory(this.toTrainerId(trainer), this.toTrainerPreset(trainer), team).create());
        }
    }

    private Map<String, List<ShowdownPokemon>> reloadTrainerTeam(class_3300 manager) {
        HashMap<String, List<ShowdownPokemon>> teams = new HashMap<String, List<ShowdownPokemon>>();
        manager.method_14488(TEAM_DIR, identifier -> identifier.toString().endsWith(".json")).forEach((identifier, resource) -> {
            try (BufferedReader reader = resource.method_43039();){
                List team = (List)GSON.fromJson((Reader)reader, new TypeToken<List<ShowdownPokemon>>(){}.getType());
                teams.put(this.toTeamId((class_2960)identifier), team);
            }
            catch (JsonParseException | IOException e) {
                CobblemonTrainerBattle.LOGGER.error("Error occurred while loading {}", identifier);
            }
        });
        return teams;
    }

    private Map<class_2960, TrainerPreset> reloadTrainerPreset(class_3300 manager) {
        HashMap<class_2960, TrainerPreset> presets = new HashMap<class_2960, TrainerPreset>();
        manager.method_14488(PRESET_DIR, identifier -> identifier.toString().endsWith(".json")).forEach((identifier, resource) -> {
            try (BufferedReader reader = resource.method_43039();){
                TrainerPreset preset = (TrainerPreset)GSON.fromJson((Reader)reader, TrainerPreset.class);
                presets.put((class_2960)identifier, preset);
            }
            catch (JsonParseException | IOException e) {
                CobblemonTrainerBattle.LOGGER.error("Error occurred while loading {}", identifier);
            }
        });
        return presets;
    }

    private boolean isValidTrainer(Map.Entry<class_2960, TrainerPreset> trainer, List<ShowdownPokemon> team) {
        if (team.isEmpty()) {
            CobblemonTrainerBattle.LOGGER.error("Unknown team : {}", (Object)this.toTrainerId(trainer));
            return false;
        }
        if (!this.isPartySizeCompatible(new BattleFormatFactory(this.toTrainerPreset(trainer).battleFormat).create(), team)) {
            CobblemonTrainerBattle.LOGGER.error("Illegal party size");
            return false;
        }
        return true;
    }

    private boolean isPartySizeCompatible(BattleFormat format, List<ShowdownPokemon> team) {
        return new MinimumPartySizePredicate.ValuePredicate(format).test(team.size());
    }

    private String toSimplePath(Map.Entry<class_2960, TrainerPreset> trainer) {
        return trainer.getKey().method_12832().replace("trainer_preset/", "");
    }

    private String toTrainerId(Map.Entry<class_2960, TrainerPreset> trainer) {
        String trainerId = trainer.getKey().method_12832();
        trainerId = trainerId.replace("trainer_preset/", "");
        trainerId = trainerId.replace(".json", "");
        return trainerId;
    }

    private TrainerPreset toTrainerPreset(Map.Entry<class_2960, TrainerPreset> preset) {
        return preset.getValue();
    }

    private String toTeamId(class_2960 team) {
        String teamId = team.toString();
        teamId = teamId.replace("trainer_team/", "");
        teamId = teamId.replace(".json", "");
        return teamId;
    }

    private String toTeamId(String team) {
        Object teamId = team;
        if (!((String)teamId).contains(":")) {
            teamId = "cobblemontrainerbattle:" + (String)teamId;
        }
        return teamId;
    }
}

