/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.mixin;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.drop.DropTable;
import com.cobblemon.mod.common.api.entity.PokemonSender;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonServerDelegate;
import com.cobblemon.mod.common.world.gamerules.CobblemonGameRules;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContext;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContextStorage;
import kotlin.ranges.IntRange;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PokemonServerDelegate.class})
public class PokemonServerDelegateMixin {
    @Inject(method={"updatePostDeath"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void cancelDrop(CallbackInfo callbackInfo) {
        if (this.isTrainerBattle()) {
            this.updatePostDeathWithoutDroppingHeldItem();
            callbackInfo.cancel();
        }
    }

    private boolean isTrainerBattle() {
        try {
            PokemonEntity entity = ((PokemonServerDelegate)this).getEntity();
            return this.getTrainerBattleIds((class_3218)entity.method_37908()).contains(entity.getBattleId());
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    private List<UUID> getTrainerBattleIds(class_3218 world) {
        ArrayList<UUID> battleIds = new ArrayList<UUID>();
        for (class_3222 player : world.method_18456()) {
            try {
                BattleContext context = BattleContextStorage.getInstance().getOrCreate(player.method_5667());
                battleIds.add(context.getTrainerBattle().getBattleId());
            }
            catch (NullPointerException nullPointerException) {}
        }
        return battleIds;
    }

    private boolean isEffectProgressDone(PokemonEntity entity) {
        try {
            return entity.getEffects().getProgress().isDone();
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    private void updatePostDeathWithoutDroppingHeldItem() {
        PokemonEntity entity = ((PokemonServerDelegate)this).getEntity();
        class_1309 owner = entity.method_35057();
        if (!((Boolean)entity.method_5841().method_12789(PokemonEntity.getDYING_EFFECTS_STARTED())).booleanValue()) {
            entity.method_5841().method_12778(PokemonEntity.getDYING_EFFECTS_STARTED(), (Object)true);
            if (owner instanceof PokemonSender && entity.getBeamMode() == -1) {
                entity.recallWithAnimation();
            }
        }
        if (entity.field_6213 == 0) {
            entity.getEffects().wipe();
            entity.field_6213 = 1;
            return;
        }
        if (!this.isEffectProgressDone(entity)) {
            return;
        }
        ++entity.field_6213;
        if (entity.field_6213 == 30 && owner != null && !(owner instanceof PokemonSender)) {
            entity.method_37908().method_45446(owner.method_24515(), CobblemonSounds.POKE_BALL_RECALL, class_3419.field_15248, 0.6f, 1.0f, true);
            entity.method_5841().method_12778(PokemonEntity.getPHASING_TARGET_ID(), (Object)owner.method_5628());
            entity.method_5841().method_12778(PokemonEntity.getBEAM_MODE(), (Object)3);
        }
        if (entity.field_6213 == 60) {
            if (entity.method_6139() == null && entity.method_35057() == null) {
                entity.method_37908().method_8421((class_1297)entity, (byte)60);
                if (entity.method_37908().method_8450().method_8355(CobblemonGameRules.DO_POKEMON_LOOT)) {
                    DropTable drops = entity.getDrops() != null ? entity.getDrops() : entity.getPokemon().getForm().getDrops();
                    drops.drop((class_1309)entity, (class_3218)entity.method_37908(), entity.method_19538(), entity.getKiller(), new IntRange(1, 1), null);
                }
            }
            entity.method_5650(class_1297.class_5529.field_26998);
        }
    }
}

