/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.mixin;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.battles.BattleRegistry;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.player.NormalLevelPlayer;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer.PokeBallEngineerBackedTrainer;
import kiwiapollo.cobblemontrainerbattle.battle.trainerbattle.EntityBackedTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.battle.trainerbattle.NullTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.battle.trainerbattle.TrainerBattle;
import kiwiapollo.cobblemontrainerbattle.entity.TrainerEntityBehavior;
import kiwiapollo.cobblemontrainerbattle.exception.BattleStartException;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContextStorage;
import kiwiapollo.cobblemontrainerbattle.villager.PokeBallEngineerVillager;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1646.class})
public class VillagerEntityMixin
implements TrainerEntityBehavior {
    private TrainerBattle trainerBattle = new NullTrainerBattle();

    @Inject(method={"interactMob"}, at={@At(value="HEAD")}, cancellable=true)
    public void interactTrainerVillager(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> callbackInfo) {
        if (!this.isPokeBallEngineer()) {
            return;
        }
        this.startTrainerBattle(player, hand, callbackInfo);
    }

    private boolean isPokeBallEngineer() {
        try {
            class_1646 villager = (class_1646)this;
            return villager.method_7231().method_16924().equals((Object)PokeBallEngineerVillager.PROFESSION);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private void startTrainerBattle(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> callbackInfo) {
        try {
            if (this.hasTrainerBattle()) {
                return;
            }
            class_1646 villager = (class_1646)this;
            EntityBackedTrainerBattle trainerBattle = new EntityBackedTrainerBattle(new NormalLevelPlayer((class_3222)player), new PokeBallEngineerBackedTrainer(villager), (class_1309)((class_1646)this));
            trainerBattle.start();
            BattleContextStorage.getInstance().getOrCreate(player.method_5667()).setTrainerBattle(trainerBattle);
            this.trainerBattle = trainerBattle;
            villager.method_18800(0.0, 0.0, 0.0);
            villager.method_5977(true);
            villager.field_6007 = true;
            callbackInfo.setReturnValue((Object)class_1269.field_5812);
            callbackInfo.cancel();
        }
        catch (ClassCastException | IllegalStateException | NoSuchElementException | BattleStartException exception) {
            // empty catch block
        }
    }

    private boolean hasTrainerBattle() {
        try {
            UUID battleId = this.trainerBattle.getBattleId();
            Cobblemon.INSTANCE.getBattleRegistry();
            return Objects.nonNull(BattleRegistry.getBattle((UUID)battleId));
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public void setTrainer(String trainer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public class_2960 getTexture() {
        throw new NullPointerException();
    }

    @Override
    public TrainerBattle getTrainerBattle() {
        UUID battleId = this.trainerBattle.getBattleId();
        Cobblemon.INSTANCE.getBattleRegistry();
        Objects.requireNonNull(BattleRegistry.getBattle((UUID)battleId));
        return this.trainerBattle;
    }

    @Override
    public void onPlayerVictory() {
        this.setAiEnabled();
    }

    @Override
    public void onPlayerDefeat() {
        this.setAiEnabled();
    }

    private void setAiEnabled() {
        class_1646 villager = (class_1646)this;
        villager.method_5977(false);
    }
}

