/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.NoSuchElementException;
import java.util.Optional;
import kiwiapollo.cobblemontrainerbattle.global.history.PlayerHistory;
import kiwiapollo.cobblemontrainerbattle.global.history.PlayerHistoryStorage;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;

public class KillTrainerCriterion
extends class_4558<Conditions> {
    public Codec<Conditions> method_54937() {
        return Conditions.CODEC;
    }

    public void trigger(class_3222 player) {
        this.method_22510(player, conditions -> conditions.test(player));
    }

    public record Conditions(Optional<String> trainer, Optional<Integer> count) implements class_4558.class_8788
    {
        private static final int ONE = 1;
        private static final int ZERO = 0;
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("trainer").forGetter(Conditions::trainer), (App)Codec.INT.optionalFieldOf("count").forGetter(Conditions::count)).apply((Applicative)instance, Conditions::new));

        public boolean test(class_3222 player) {
            return this.getPlayerKillCount(player) >= this.count.orElse(1);
        }

        private int getPlayerKillCount(class_3222 player) {
            if (this.trainer().isEmpty()) {
                return this.getTotalKillCount(player);
            }
            return this.getTrainerKillCount(player);
        }

        private int getTotalKillCount(class_3222 player) {
            PlayerHistory history = PlayerHistoryStorage.getInstance().getOrCreate(player.method_5667());
            return history.getTotalTrainerKillCount();
        }

        private int getTrainerKillCount(class_3222 player) {
            try {
                PlayerHistory history = PlayerHistoryStorage.getInstance().getOrCreate(player.method_5667());
                return history.getOrCreate(this.trainer.orElseThrow()).getKillCount();
            }
            catch (NoSuchElementException e) {
                return 0;
            }
        }

        public Optional<class_5258> comp_2029() {
            return Optional.empty();
        }
    }
}

