/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.battle.predicate;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.List;
import kiwiapollo.cobblemontrainerbattle.CobblemonTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.player.PlayerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MessagePredicate;
import kiwiapollo.cobblemontrainerbattle.pokemon.ShowdownPokemon;
import kiwiapollo.cobblemontrainerbattle.pokemon.ShowdownPokemonParser;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public abstract class PokemonPredicate
implements MessagePredicate<PlayerBattleParticipant> {
    protected boolean containsPokemon(List<Pokemon> party, ShowdownPokemon required) {
        for (Pokemon p : party) {
            if (!this.isSpeciesEqual(p, required) || !this.isFormEqual(p, required)) continue;
            return true;
        }
        return false;
    }

    private boolean isSpeciesEqual(Pokemon party, ShowdownPokemon required) {
        try {
            class_2960 p = party.getSpecies().getResourceIdentifier();
            class_2960 r = ShowdownPokemonParser.toSpecies(required).getResourceIdentifier();
            return p.equals((Object)r);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private boolean isFormEqual(Pokemon party, ShowdownPokemon required) {
        if (required.form == null) {
            return true;
        }
        return party.getForm().getName().equals(required.form);
    }

    protected class_2561 toPokemonDescriptor(ShowdownPokemon pokemon) {
        try {
            if (pokemon.form == null) {
                Species species = ShowdownPokemonParser.toSpecies(pokemon);
                return species.getTranslatedName();
            }
            Species species = ShowdownPokemonParser.toSpecies(pokemon);
            return species.getTranslatedName().method_27693(" ").method_27693(pokemon.form);
        }
        catch (NullPointerException e) {
            Species species = ShowdownPokemonParser.toSpecies(pokemon);
            CobblemonTrainerBattle.LOGGER.error("Unknown Pokemon species: {}", (Object)species.getResourceIdentifier());
            throw new IllegalStateException(e);
        }
    }
}

