/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.battle.trainerbattle;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.ai.StrongBattleAI;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.CobblemonTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.advancement.CustomCriteria;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.BattleAIFactory;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.player.PlayerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer.TrainerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MessagePredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MinimumPartySizePredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.PlayerNotBusyPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.PlayerPartyNotEmptyPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.PlayerPartyNotFaintedPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.trainerbattle.TrainerBattle;
import kiwiapollo.cobblemontrainerbattle.exception.BattleStartException;
import kiwiapollo.cobblemontrainerbattle.global.history.BattleRecord;
import kiwiapollo.cobblemontrainerbattle.global.history.PlayerHistoryStorage;
import kotlin.Unit;
import net.minecraft.class_2561;
import net.minecraft.class_3414;

public class AbstractTrainerBattle
implements TrainerBattle {
    private final PlayerBattleParticipant player;
    private final TrainerBattleParticipant trainer;
    private UUID battleId;

    public AbstractTrainerBattle(PlayerBattleParticipant player, TrainerBattleParticipant trainer) {
        this.player = player;
        this.trainer = trainer;
        this.doStrongAIHotFix(trainer);
    }

    private void doStrongAIHotFix(TrainerBattleParticipant trainer) {
        BattleAI battleAI = trainer.getBattleAI();
        if (battleAI instanceof StrongBattleAI) {
            StrongBattleAI strong = (StrongBattleAI)battleAI;
            trainer.setBattleAI(new BattleAIFactory("ignored", trainer.getBattleAIName()).create());
        }
    }

    @Override
    public void start() throws BattleStartException {
        for (MessagePredicate<PlayerBattleParticipant> predicate : this.getPredicates()) {
            if (predicate.test(this.player)) continue;
            this.player.sendErrorMessage(predicate.getErrorMessage());
            throw new BattleStartException();
        }
        Cobblemon.INSTANCE.getStorage().getParty(this.player.getPlayerEntity()).toGappyList().stream().filter(Objects::nonNull).forEach(Pokemon::recall);
        Cobblemon.INSTANCE.getBattleRegistry();
        BattleRegistry.startBattle((BattleFormat)this.trainer.getBattleFormat(), (BattleSide)new BattleSide(new BattleActor[]{this.player.createBattleActor()}), (BattleSide)new BattleSide(new BattleActor[]{this.trainer.createBattleActor(this.player.getPlayerEntity())}), (boolean)false).ifSuccessful(pokemonBattle -> {
            this.battleId = pokemonBattle.getBattleId();
            PlayerBattleActor actor = (PlayerBattleActor)pokemonBattle.getActor(this.player.getPlayerEntity());
            class_3414 battleTheme = this.trainer.getBattleTheme().orElse(CobblemonSounds.PVN_BATTLE);
            actor.setBattleTheme(battleTheme.method_14833());
            this.player.sendInfoMessage(class_2561.method_43469((String)"command.cobblemontrainerbattle.success.trainerbattle", (Object[])new Object[]{this.trainer.getName()}));
            CobblemonTrainerBattle.LOGGER.info("Started trainer battle : {} versus {}", (Object)this.player.getName(), (Object)this.trainer.getId());
            return Unit.INSTANCE;
        });
    }

    private List<MessagePredicate<PlayerBattleParticipant>> getPredicates() {
        ArrayList<MessagePredicate<PlayerBattleParticipant>> predicates = new ArrayList<MessagePredicate<PlayerBattleParticipant>>();
        predicates.addAll(List.of(new PlayerNotBusyPredicate.PlayerBattleParticipantPredicate(), new PlayerPartyNotEmptyPredicate(), new PlayerPartyNotFaintedPredicate(), new MinimumPartySizePredicate.PlayerPredicate(this.trainer.getBattleFormat())));
        predicates.addAll(this.trainer.getPredicates());
        return predicates;
    }

    @Override
    public void onPlayerVictory() {
        this.trainer.onPlayerVictory(this.player.getPlayerEntity());
        this.updateVictoryRecord();
        CustomCriteria.DEFEAT_TRAINER_CRITERION.trigger(this.player.getPlayerEntity());
    }

    @Override
    public void onPlayerDefeat() {
        this.trainer.onPlayerDefeat(this.player.getPlayerEntity());
        this.updateDefeatRecord();
    }

    @Override
    public UUID getBattleId() {
        return this.battleId;
    }

    @Override
    public PlayerBattleParticipant getPlayer() {
        return this.player;
    }

    @Override
    public TrainerBattleParticipant getTrainer() {
        return this.trainer;
    }

    private BattleRecord getBattleRecord() {
        return PlayerHistoryStorage.getInstance().getOrCreate(this.getPlayer().getUuid()).getOrCreate(this.getTrainer().getId());
    }

    private void updateVictoryRecord() {
        this.getBattleRecord().setVictoryCount(this.getBattleRecord().getVictoryCount() + 1);
    }

    private void updateDefeatRecord() {
        this.getBattleRecord().setDefeatCount(this.getBattleRecord().getDefeatCount() + 1);
    }
}

