/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.command.executor;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import kiwiapollo.cobblemontrainerbattle.CobblemonTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContext;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContextStorage;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class RentalPokemonTrader
implements Command<class_2168> {
    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (!this.isRentalPokemonExist(player)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"command.cobblemontrainerbattle.error.rentalpokemon.rental_pokemon_not_exist").method_27692(class_124.field_1061));
                return 0;
            }
            if (!this.isTradablePokemonExist(player)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"command.cobblemontrainerbattle.error.rentalpokemon.tradable_pokemon_not_exist").method_27692(class_124.field_1061));
                return 0;
            }
            int playerslot = IntegerArgumentType.getInteger(context, (String)"playerslot");
            int trainerslot = IntegerArgumentType.getInteger(context, (String)"trainerslot");
            Pokemon playerPokemon = this.getPlayerPokemon(player, playerslot);
            Pokemon trainerPokemon = this.getTrainerPokemon(player, trainerslot);
            this.setRentalPokemon(player, playerslot, trainerPokemon);
            this.clearTradablePokemon(player);
            player.method_43496((class_2561)class_2561.method_43469((String)"command.cobblemontrainerbattle.success.rentalpokemon.trade", (Object[])new Object[]{playerPokemon.getDisplayName(false), trainerPokemon.getDisplayName(false)}));
            CobblemonTrainerBattle.LOGGER.info("{} traded {} for {}", new Object[]{player.method_5477(), playerPokemon.getDisplayName(false), trainerPokemon.getDisplayName(false)});
            return 1;
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
    }

    private boolean isRentalPokemonExist(class_3222 player) {
        BattleContext context = BattleContextStorage.getInstance().getOrCreate(player.method_5667());
        return context.getRentalPokemon().occupied() != 0;
    }

    private void clearTradablePokemon(class_3222 player) {
        BattleContext context = BattleContextStorage.getInstance().getOrCreate(player.method_5667());
        context.clearTradablePokemon();
    }

    private boolean isTradablePokemonExist(class_3222 player) {
        BattleContext context = BattleContextStorage.getInstance().getOrCreate(player.method_5667());
        return context.getTradablePokemon().occupied() != 0;
    }

    private void setRentalPokemon(class_3222 player, int slot, Pokemon trainerPokemon) {
        BattleContext context = BattleContextStorage.getInstance().getOrCreate(player.method_5667());
        context.getRentalPokemon().set(slot, trainerPokemon);
    }

    private Pokemon getPlayerPokemon(class_3222 player, int slot) {
        BattleContext context = BattleContextStorage.getInstance().getOrCreate(player.method_5667());
        return context.getRentalPokemon().get(slot);
    }

    private Pokemon getTrainerPokemon(class_3222 player, int slot) {
        BattleContext context = BattleContextStorage.getInstance().getOrCreate(player.method_5667());
        return context.getTradablePokemon().get(slot);
    }
}

