/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.command.executor;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.player.PlayerBattleParticipantFactory;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer.TrainerBattleParticipantFactory;
import kiwiapollo.cobblemontrainerbattle.battle.random.RandomTrainerBattleTrainerFactory;
import kiwiapollo.cobblemontrainerbattle.battle.trainerbattle.PlayerBackedTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.common.LevelMode;
import kiwiapollo.cobblemontrainerbattle.exception.BattleStartException;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContextStorage;
import kiwiapollo.cobblemontrainerbattle.global.preset.TrainerStorage;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public abstract class TrainerBattleStarter
implements Command<class_2168> {
    public int run(class_3222 player, String trainer) {
        try {
            if (!this.isKnownTrainer(trainer)) {
                player.method_43496((class_2561)class_2561.method_43469((String)"command.cobblemontrainerbattle.error.trainerbattle.unknown_trainer", (Object[])new Object[]{trainer}).method_27692(class_124.field_1061));
                return 0;
            }
            PlayerBackedTrainerBattle trainerBattle = new PlayerBackedTrainerBattle(new PlayerBattleParticipantFactory(player, this.getLevelmode(trainer)).create(), new TrainerBattleParticipantFactory(trainer).create());
            trainerBattle.start();
            BattleContextStorage.getInstance().getOrCreate(player.method_5667()).setTrainerBattle(trainerBattle);
            return 1;
        }
        catch (BattleStartException e) {
            return 0;
        }
    }

    private boolean isKnownTrainer(String trainer) {
        return TrainerStorage.getInstance().keySet().contains(trainer);
    }

    private LevelMode getLevelmode(String trainer) {
        return TrainerStorage.getInstance().get(trainer).getLevelMode();
    }

    public static class BetweenOtherPlayerAndRandomTrainer
    extends TrainerBattleStarter {
        public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 player = class_2186.method_9315(context, (String)"player");
            String trainer = new RandomTrainerBattleTrainerFactory().create();
            return super.run(player, trainer);
        }
    }

    public static class BetweenOtherPlayerAndSelectedTrainer
    extends TrainerBattleStarter {
        public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 player = class_2186.method_9315(context, (String)"player");
            String trainer = StringArgumentType.getString(context, (String)"trainer");
            return super.run(player, trainer);
        }
    }

    public static class BetweenThisPlayerAndRandomTrainer
    extends TrainerBattleStarter {
        public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            String trainer = new RandomTrainerBattleTrainerFactory().create();
            return super.run(player, trainer);
        }
    }

    public static class BetweenThisPlayerAndSelectedTrainer
    extends TrainerBattleStarter {
        public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            String trainer = StringArgumentType.getString(context, (String)"trainer");
            return super.run(player, trainer);
        }
    }
}

