/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.entity;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.status.PersistentStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import kiwiapollo.cobblemontrainerbattle.entity.RandomPersistentStatusFactory;
import kiwiapollo.cobblemontrainerbattle.entity.TrainerEntity;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class HostileTrainerEntity
extends TrainerEntity {
    public HostileTrainerEntity(class_1299<? extends class_1314> type, class_1937 world) {
        super(type, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public boolean method_6121(class_1297 target) {
        this.applyRandomPersistentStatus((class_3222)target);
        return super.method_6121(target);
    }

    private void applyRandomPersistentStatus(class_3222 player) {
        try {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            ArrayList<Pokemon> random = new ArrayList<Pokemon>(party.toGappyList().stream().filter(Objects::nonNull).filter(pokemon -> !pokemon.isFainted()).filter(pokemon -> !this.hasPersistentStatus((Pokemon)pokemon)).toList());
            Collections.shuffle(random);
            Pokemon pokemon2 = (Pokemon)random.get(0);
            PersistentStatus status = new RandomPersistentStatusFactory().create();
            pokemon2.applyStatus(status);
            player.method_43496((class_2561)class_2561.method_43469((String)status.getApplyMessage(), (Object[])new Object[]{pokemon2.getDisplayName(false)}).method_27692(class_124.field_1061));
        }
        catch (ClassCastException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    private boolean hasPersistentStatus(Pokemon pokemon) {
        try {
            return !pokemon.getStatus().isExpired();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public void onPlayerVictory() {
        this.dropDefeatedInBattleLoot();
        this.method_31472();
    }

    @Override
    public void onPlayerDefeat() {
        super.onPlayerDefeat();
        this.setRandomPlayerPokemonFaint();
    }

    private void setRandomPlayerPokemonFaint() {
        try {
            class_3222 player = this.getTrainerBattle().getPlayer().getPlayerEntity();
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            ArrayList<Pokemon> random = new ArrayList<Pokemon>(party.toGappyList().stream().filter(Objects::nonNull).filter(pokemon -> !pokemon.isFainted()).toList());
            Collections.shuffle(random);
            Pokemon pokemon2 = (Pokemon)random.get(0);
            pokemon2.setCurrentHealth(0);
            player.method_43496((class_2561)class_2561.method_43469((String)"cobblemon.battle.fainted", (Object[])new Object[]{pokemon2.getDisplayName(false)}).method_27692(class_124.field_1061));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

