/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.event;

import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.global.context.BattleContextStorage;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.minecraft.class_3222;

public class BattleVictoryEventHandler
implements Function1<BattleVictoryEvent, Unit> {
    public Unit invoke(BattleVictoryEvent event) {
        if (!this.isTrainerBattle(event)) {
            return Unit.INSTANCE;
        }
        if (this.isPlayerVictory(event)) {
            this.onPlayerVictory(event);
        } else {
            this.onPlayerDefeat(event);
        }
        return Unit.INSTANCE;
    }

    private boolean isTrainerBattle(BattleVictoryEvent event) {
        try {
            class_3222 player = (class_3222)event.getBattle().getPlayers().get(0);
            UUID battleId = BattleContextStorage.getInstance().getOrCreate(player.method_5667()).getTrainerBattle().getBattleId();
            return battleId.equals(event.getBattle().getBattleId());
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private boolean isPlayerVictory(BattleVictoryEvent event) {
        class_3222 player = (class_3222)event.getBattle().getPlayers().get(0);
        return event.getWinners().stream().anyMatch(battleActor -> battleActor.isForPlayer(player));
    }

    private void onPlayerVictory(BattleVictoryEvent event) {
        class_3222 player = (class_3222)event.getBattle().getPlayers().get(0);
        BattleContextStorage.getInstance().getOrCreate(player.method_5667()).getTrainerBattle().onPlayerVictory();
        BattleContextStorage.getInstance().getOrCreate(player.method_5667()).clearTrainerBattle();
    }

    private void onPlayerDefeat(BattleVictoryEvent event) {
        class_3222 player = (class_3222)event.getBattle().getPlayers().get(0);
        BattleContextStorage.getInstance().getOrCreate(player.method_5667()).getTrainerBattle().onPlayerDefeat();
        BattleContextStorage.getInstance().getOrCreate(player.method_5667()).clearTrainerBattle();
    }
}

