/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer;

import com.cobblemon.mod.common.api.battles.model.actor.AIBattleActor;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.battle.battleactor.EntityBackedTrainerBattleActor;
import kiwiapollo.cobblemontrainerbattle.battle.battleactor.SafeCopyBattlePokemonFactory;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.BattleAIFactory;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.BattleFormatFactory;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer.TrainerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.global.preset.TrainerPreset;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.server.MinecraftServer;

public abstract class AbstractTrainerBattleParticipant
implements TrainerBattleParticipant {
    private static final int MINIMUM_ENTITY_DISTANCE = 10;
    private final String id;
    private final UUID uuid;
    private final String name;
    private final PartyStore party;
    private final BattleFormat battleFormat;
    private BattleAI battleAI;
    private final class_3414 battleTheme;
    private final UUID entityUuid;
    private final class_2960 texture;
    private final boolean isSpawningAllowed;
    private final List<String> onVictoryCommands;
    private final List<String> onDefeatCommands;
    private final String battleAIName;

    public AbstractTrainerBattleParticipant(String id, TrainerPreset preset, PartyStore party) {
        this.id = id;
        this.uuid = UUID.randomUUID();
        this.name = class_2561.method_43471((String)Optional.ofNullable(preset.displayName).orElse(id)).getString();
        this.party = party;
        this.battleFormat = new BattleFormatFactory(preset.battleFormat).create();
        this.battleAI = new BattleAIFactory(preset.battleFormat, preset.battleAI).create();
        this.battleAIName = preset.battleAI;
        this.battleTheme = class_3414.method_47908((class_2960)class_2960.method_12829((String)preset.battleTheme));
        this.entityUuid = AbstractTrainerBattleParticipant.toUUID(preset.entityUuid);
        this.texture = class_2960.method_12829((String)preset.texture);
        this.isSpawningAllowed = preset.isSpawningAllowed;
        this.onVictoryCommands = preset.onVictoryCommands;
        this.onDefeatCommands = preset.onDefeatCommands;
    }

    private static UUID toUUID(String uuid) {
        try {
            return UUID.fromString(Objects.requireNonNull(uuid));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return UUID.randomUUID();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public BattleFormat getBattleFormat() {
        return this.battleFormat;
    }

    @Override
    public BattleAI getBattleAI() {
        return this.battleAI;
    }

    @Override
    @Deprecated
    public void setBattleAI(BattleAI battleAI) {
        this.battleAI = battleAI;
    }

    @Override
    @Deprecated
    public String getBattleAIName() {
        return this.battleAIName;
    }

    @Override
    public Optional<class_3414> getBattleTheme() {
        return Optional.ofNullable(this.battleTheme);
    }

    @Override
    public boolean isSpawningAllowed() {
        return this.isSpawningAllowed;
    }

    @Override
    public AIBattleActor createBattleActor(class_3222 player) {
        return new EntityBackedTrainerBattleActor(this.getName(), this.getUuid(), this.getBattleTeam(player), this.getBattleAI(), this.getEntityOrPlayer(player));
    }

    private class_1309 getEntityOrPlayer(class_3222 player) {
        try {
            return this.getEntity(player);
        }
        catch (NullPointerException e) {
            return player;
        }
    }

    @Override
    public class_1309 getEntity(class_3222 player) {
        try {
            class_1309 entity = (class_1309)player.method_51469().method_14190(this.entityUuid);
            if (entity.method_5739((class_1297)player) > 10.0f) {
                throw new NullPointerException();
            }
            return entity;
        }
        catch (ClassCastException e) {
            throw new NullPointerException();
        }
    }

    @Override
    public void onPlayerVictory(class_3222 player) {
        this.onVictoryCommands.forEach(command -> this.executeCommand((String)command, player));
    }

    @Override
    public void onPlayerDefeat(class_3222 player) {
        this.onDefeatCommands.forEach(command -> this.executeCommand((String)command, player));
    }

    @Override
    public PartyStore getParty() {
        return this.party;
    }

    @Override
    public List<BattlePokemon> getBattleTeam(class_3222 player) {
        List<BattlePokemon> team = this.getParty().toGappyList().stream().filter(Objects::nonNull).map(new SafeCopyBattlePokemonFactory()).toList();
        team.forEach(pokemon -> pokemon.getEffectedPokemon().heal());
        return team;
    }

    private void executeCommand(String command, class_3222 player) {
        command = command.replace("%player%", player.method_7334().getName());
        MinecraftServer server = player.method_5671().method_9211();
        CommandDispatcher dispatcher = server.method_3734().method_9235();
        server.method_3734().method_9249(dispatcher.parse(command, (Object)server.method_3739()), command);
    }

    @Override
    public class_2960 getTexture() {
        return this.texture;
    }
}

