/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.event;

import java.util.ArrayList;
import java.util.List;
import kiwiapollo.cobblemontrainerbattle.event.HostileTrainerEntitySpawner;
import kiwiapollo.cobblemontrainerbattle.event.NeutralTrainerEntitySpawner;
import kiwiapollo.cobblemontrainerbattle.event.TrainerEntitySpawner;
import kiwiapollo.cobblemontrainerbattle.event.WeightedEntitySpawner;
import kiwiapollo.cobblemontrainerbattle.global.config.ConfigStorage;
import kiwiapollo.cobblemontrainerbattle.item.VsSeeker;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;

public class TrainerEntitySpawnerScheduler
implements ServerTickEvents.EndWorldTick {
    private static final List<TrainerEntitySpawner> SPAWNERS = List.of(new NeutralTrainerEntitySpawner(90), new HostileTrainerEntitySpawner(10));

    public void onEndTick(class_3218 world) {
        if (!this.isTrainerSpawnTick(world.method_8503().method_3780())) {
            return;
        }
        for (class_3222 player : world.method_18456()) {
            if (!this.hasVsSeeker(player) || !this.isBelowMaximumTrainerSpawnCount(world, player)) continue;
            this.getRandomSpawner(this.getSpawners()).spawnEntity(world, player);
        }
    }

    private boolean isTrainerSpawnTick(int ticks) {
        int interval = ConfigStorage.getInstance().getTrainerSpawnIntervalInSeconds() * 20;
        return ticks % interval == 0;
    }

    private boolean hasVsSeeker(class_3222 player) {
        return !VsSeeker.getVsSeekers(player.method_31548()).isEmpty();
    }

    private boolean isBelowMaximumTrainerSpawnCount(class_3218 world, class_3222 player) {
        int maximum;
        int total = SPAWNERS.stream().map(spawner -> spawner.getEntityCount(world, player)).mapToInt(Integer::intValue).sum();
        return total < (maximum = ConfigStorage.getInstance().getMaximumTrainerSpawnCount());
    }

    private TrainerEntitySpawner getRandomSpawner(List<TrainerEntitySpawner> spawners) {
        int total = spawners.stream().map(WeightedEntitySpawner::getWeight).mapToInt(Integer::intValue).sum();
        int random = class_5819.method_43047().method_43048(total) + 1;
        for (TrainerEntitySpawner spawner : spawners) {
            int weight = spawner.getWeight();
            if (random <= weight) {
                return spawner;
            }
            random -= weight;
        }
        throw new IllegalStateException();
    }

    private List<TrainerEntitySpawner> getSpawners() {
        List<TrainerEntitySpawner> spawners = new ArrayList<TrainerEntitySpawner>(SPAWNERS);
        if (!ConfigStorage.getInstance().getAllowHostileTrainerSpawn()) {
            spawners = spawners.stream().filter(spawner -> !(spawner instanceof HostileTrainerEntitySpawner)).toList();
        }
        return spawners;
    }
}

