/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.global.config;

import com.google.gson.Gson;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import kiwiapollo.cobblemontrainerbattle.CobblemonTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.global.config.Config;
import kiwiapollo.cobblemontrainerbattle.global.config.ConfigStorage;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class ConfigLoader
implements Command<class_2168> {
    private static final File CONFIG_DIR = new File(FabricLoader.getInstance().getConfigDir().toFile(), "cobblemontrainerbattle");
    private static final File CONFIG_FILE = new File(CONFIG_DIR, "config.json");
    private static final Gson GSON = new Gson();

    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            ConfigStorage.getInstance().update(this.load());
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            player.method_43496((class_2561)class_2561.method_43471((String)"command.cobblemontrainerbattle.success.reload"));
            CobblemonTrainerBattle.LOGGER.info("Loaded configuration");
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Config load() {
        try {
            return this.loadExistingConfig();
        }
        catch (IllegalStateException e) {
            CobblemonTrainerBattle.LOGGER.error("Failed to load config");
            this.copyDefaultConfig();
            return this.loadDefaultConfig();
        }
    }

    private void copyDefaultConfig() {
        try (InputStream defaults = this.getDefaultConfigInputStream();){
            if (!CONFIG_DIR.exists()) {
                CONFIG_DIR.mkdirs();
            }
            Files.copy(defaults, CONFIG_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Config loadExistingConfig() {
        Config config;
        FileReader reader = new FileReader(CONFIG_FILE);
        try {
            config = (Config)GSON.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        reader.close();
        return config;
    }

    private Config loadDefaultConfig() {
        Config config;
        InputStreamReader reader = new InputStreamReader(this.getDefaultConfigInputStream());
        try {
            config = (Config)GSON.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return config;
    }

    private InputStream getDefaultConfigInputStream() {
        return ConfigLoader.class.getClassLoader().getResourceAsStream("config/defaults.json");
    }
}

